/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavAttachment;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavTempFile;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavWikiFile;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavResource;
import com.xpn.xwiki.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavPage
extends AbstractDavResource {
    private static final Logger LOG = LoggerFactory.getLogger(DavPage.class);
    private String spaceName;
    private XWikiDocument doc;

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            throw new DavException(400);
        }
        this.spaceName = name.substring(0, dot);
        try {
            this.doc = this.xwikiContext.getWiki().getDocument(this.name, this.xwikiContext);
        }
        catch (XWikiException e) {
            throw new DavException(500, (Throwable)e);
        }
        String timeStamp = DavConstants.creationDateFormat.format(this.doc.getCreationDate());
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        timeStamp = DavConstants.modificationDateFormat.format(this.doc.getContentUpdateDate());
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)"text/directory"));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.doc.getLanguage()));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)0));
    }

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            boolean last = next + 1 == tokens.length;
            String nextToken = tokens[next];
            String relativePath = "/" + nextToken;
            int dot = nextToken.indexOf(46);
            if (dot != -1) {
                if (dot == 0) {
                    DavTempFile davTempFile = new DavTempFile();
                    davTempFile.init(this, nextToken, relativePath);
                    stack.push(davTempFile);
                } else if (!last || this.xwikiContext.getWiki().exists(nextToken, this.xwikiContext) || DavMethods.isCreateCollectionRequest((DavServletRequest)((DavServletRequest)this.xwikiContext.getRequest().getHttpServletRequest()))) {
                    DavPage davPage = new DavPage();
                    davPage.init(this, nextToken, relativePath);
                    stack.push(davPage);
                    davPage.decode(stack, tokens, next + 1);
                } else if (nextToken.equals("wiki.txt") || nextToken.equals("wiki.xml")) {
                    DavWikiFile wikiFile = new DavWikiFile();
                    wikiFile.init(this, nextToken, relativePath);
                    stack.push(wikiFile);
                } else {
                    DavAttachment attachment = new DavAttachment();
                    attachment.init(this, nextToken, relativePath);
                    stack.push(attachment);
                }
            } else if (!last || this.xwikiContext.getWiki().exists(this.spaceName + "." + nextToken, this.xwikiContext) || DavMethods.isCreateCollectionRequest((DavServletRequest)((DavServletRequest)this.xwikiContext.getRequest().getHttpServletRequest()))) {
                DavPage davPage = new DavPage();
                davPage.init(this, this.spaceName + "." + nextToken, relativePath);
                stack.push(davPage);
                davPage.decode(stack, tokens, next + 1);
            } else {
                DavAttachment attachment = new DavAttachment();
                attachment.init(this, nextToken, relativePath);
                stack.push(attachment);
            }
        }
    }

    public boolean exists() {
        return !this.doc.isNew();
    }

    public boolean isCollection() {
        return true;
    }

    public void spool(OutputContext outputContext) throws IOException {
        throw new IOException("Spooling is not supported yet.");
    }

    public DavResourceIterator getMembers() {
        ArrayList<XWikiDavResource> children = new ArrayList<XWikiDavResource>();
        try {
            String sql = "where doc.parent='" + this.name + "'";
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames(sql, 0, 0, this.xwikiContext);
            for (String docName : docNames) {
                if (!this.xwikiContext.getWiki().getRightService().hasAccessLevel("view", this.xwikiContext.getUser(), docName, this.xwikiContext)) continue;
                XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(docName, this.xwikiContext);
                DavPage page = new DavPage();
                if (childDoc.getSpace().equals(this.spaceName)) {
                    page.init(this, docName, "/" + childDoc.getName());
                } else {
                    page.init(this, docName, "/" + docName);
                }
                children.add(page);
            }
            DavWikiFile wikiText = new DavWikiFile();
            wikiText.init(this, "wiki.txt", "/wiki.txt");
            children.add(wikiText);
            DavWikiFile wikiXml = new DavWikiFile();
            wikiXml.init(this, "wiki.xml", "/wiki.xml");
            children.add(wikiXml);
            sql = "select attach.filename from XWikiAttachment as attach, XWikiDocument as doc where attach.docId=doc.id and doc.fullName='" + this.name + "'";
            List attachments = this.xwikiContext.getWiki().getStore().search(sql, 0, 0, this.xwikiContext);
            for (int i = 0; i < attachments.size(); ++i) {
                String filename = (String)attachments.get(i);
                DavAttachment attachment = new DavAttachment();
                attachment.init(this, filename, "/" + filename);
                children.add(attachment);
            }
            for (XWikiDavResource sessionResource : this.getSessionResources()) {
                children.add(sessionResource);
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        catch (DavException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    protected void addAttachment(String fileName, byte[] data, XWikiDocument doc, XWikiContext xwikiContext) throws XWikiException {
        String filename;
        XWikiAttachment attachment;
        int i = fileName.indexOf("\\");
        if (i == -1) {
            i = fileName.indexOf("/");
        }
        if ((attachment = doc.getAttachment(filename = fileName.substring(i + 1))) == null) {
            attachment = new XWikiAttachment();
            doc.getAttachmentList().add(attachment);
        }
        attachment.setContent(data);
        attachment.setFilename(filename);
        attachment.setAuthor(xwikiContext.getUser());
        attachment.setDoc(doc);
        doc.saveAttachmentContent(attachment, xwikiContext);
        xwikiContext.getWiki().saveDocument(doc, "Attachment " + filename + " added", xwikiContext);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        boolean isFile;
        boolean bl = isFile = inputContext.getInputStream() != null;
        if (isFile) {
            try {
                String fName = resource.getDisplayName();
                byte[] data = Util.getFileContentAsBytes((InputStream)inputContext.getInputStream());
                if (fName.equals("wiki.txt")) {
                    this.doc.setContent(new String(data));
                    this.xwikiContext.getWiki().saveDocument(this.doc, "Updated from WebDAV", this.xwikiContext);
                }
                if (fName.equals("wiki.xml")) {
                    throw new DavException(405);
                }
                if (fName.startsWith(".")) {
                    DavTempFile tempFile = (DavTempFile)resource;
                    tempFile.setdData(data);
                    this.getSessionResources().add(tempFile);
                }
                this.addAttachment(fName, data, this.doc, this.xwikiContext);
            }
            catch (IOException e) {
                throw new DavException(500, (Throwable)e);
            }
            catch (XWikiException e) {
                throw new DavException(500, (Throwable)e);
            }
        } else {
            String pName = resource.getDisplayName();
            try {
                XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(pName, this.xwikiContext);
                childDoc.setContent("This page was created thorugh xwiki-webdav interface.");
                childDoc.setParent(this.name);
                this.xwikiContext.getWiki().saveDocument(childDoc, this.xwikiContext);
            }
            catch (XWikiException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
    }

    public void removeMember(DavResource member) throws DavException {
        String mName = member.getDisplayName();
        if (!mName.equals("wiki.txt") && !mName.equals("wiki.xml")) {
            if (mName.startsWith(".")) {
                this.getSessionResources().remove(member);
            } else {
                if (this.doc.getAttachment(mName) != null) {
                    try {
                        this.doc.deleteAttachment(this.doc.getAttachment(mName), this.xwikiContext);
                    }
                    catch (XWikiException e) {
                        throw new DavException(500, (Throwable)e);
                    }
                }
                try {
                    XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(mName, this.xwikiContext);
                    if (!childDoc.isNew()) {
                        this.xwikiContext.getWiki().deleteDocument(childDoc, this.xwikiContext);
                    }
                }
                catch (XWikiException e) {
                    throw new DavException(500, (Throwable)e);
                }
            }
        }
    }

    public void move(DavResource destination) throws DavException {
        block6: {
            XWikiDavResource dResource = (XWikiDavResource)destination;
            String dSpaceName = null;
            String dPageName = null;
            int dot = dResource.getDisplayName().lastIndexOf(46);
            if (dot != -1) {
                dSpaceName = dResource.getDisplayName().substring(0, dot);
                dPageName = dResource.getDisplayName().substring(dot + 1);
            } else {
                dSpaceName = this.spaceName;
                dPageName = dResource.getDisplayName();
            }
            try {
                List spaces = this.xwikiContext.getWiki().getSpaces(this.xwikiContext);
                if (spaces.contains(dSpaceName)) {
                    String newDocName = dSpaceName + "." + dPageName;
                    String sql = "where doc.parent='" + this.name + "'";
                    List childDocNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames(sql, 0, 0, this.xwikiContext);
                    this.doc.rename(newDocName, this.xwikiContext);
                    for (String childDocName : childDocNames) {
                        XWikiDocument childDoc = this.xwikiContext.getWiki().getDocument(childDocName, this.xwikiContext);
                        childDoc.setParent(newDocName);
                        this.xwikiContext.getWiki().saveDocument(childDoc, this.xwikiContext);
                    }
                    break block6;
                }
                throw new DavException(400);
            }
            catch (XWikiException e) {
                throw new DavException(500, (Throwable)e);
            }
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        throw new DavException(501);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(501);
    }

    public void setProperty(DavProperty property) throws DavException {
        throw new DavException(501);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getHref() {
        return this.locator.getHref(false);
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.doc.getContentUpdateDate().getTime();
        }
        return -1L;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, PROPPATCH, COPY, DELETE, MOVE, LOCK, UNLOCK";
    }

    public XWikiDocument getDocument() {
        return this.doc;
    }
}

