/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.domain;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavPage;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DavWikiFile
extends AbstractDavFile {
    private static final Logger LOG = LoggerFactory.getLogger(DavWikiFile.class);
    public static final String WIKI_TXT = "wiki.txt";
    public static final String WIKI_XML = "wiki.xml";
    private XWikiDocument parentDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        super.init(parent, name, relativePath);
        if (!name.equals(WIKI_TXT) && !name.equals(WIKI_XML)) {
            throw new DavException(500);
        }
        this.parentDoc = ((DavPage)parent).getDocument();
        String timeStamp = DavConstants.creationDateFormat.format(this.parentDoc.getCreationDate());
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        timeStamp = DavConstants.modificationDateFormat.format(this.parentDoc.getContentUpdateDate());
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETETAG, (Object)timeStamp));
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLANGUAGE, (Object)this.parentDoc.getLanguage()));
        String contentType = this.name.equals(WIKI_TXT) ? "text/plain" : "text/xml";
        this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTTYPE, (Object)contentType));
        int contentLength = 0;
        try {
            contentLength = this.name.equals(WIKI_TXT) ? this.parentDoc.getContent().length() : this.parentDoc.toXML(this.xwikiContext).length();
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        finally {
            this.davPropertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)contentLength));
        }
    }

    public boolean exists() {
        return !this.parentDoc.isNew();
    }

    public void spool(OutputContext outputContext) throws IOException {
        OutputStream out;
        if (this.exists() && (out = outputContext.getOutputStream()) != null) {
            try {
                String content = this.name.equals(WIKI_TXT) ? this.parentDoc.getContent() : this.parentDoc.toXML(this.xwikiContext);
                out.write(content.getBytes());
                out.flush();
            }
            catch (XWikiException ex) {
                throw new IOException(ex.getFullMessage());
            }
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(501);
    }

    public void move(DavResource destination) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        throw new DavException(501);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(501);
    }

    public void setProperty(DavProperty property) throws DavException {
        throw new DavException(501);
    }

    public long getModificationTime() {
        if (this.exists()) {
            return this.parentDoc.getContentUpdateDate().getTime();
        }
        return -1L;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, PROPPATCH, COPY, LOCK, UNLOCK";
    }
}

