/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.views.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.partial.AbstractDavView;
import com.xpn.xwiki.plugin.webdav.resources.views.attachments.AttachmentsBySpaceNameSubView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsView
extends AbstractDavView {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentsView.class);

    @Override
    public void decode(Stack<XWikiDavResource> stack, String[] tokens, int next) throws DavException {
        if (next < tokens.length) {
            String spaceName = tokens[next];
            AttachmentsBySpaceNameSubView subView = new AttachmentsBySpaceNameSubView();
            subView.init(this, spaceName, "/" + spaceName);
            stack.push(subView);
            subView.decode(stack, tokens, next + 1);
        }
    }

    public DavResourceIterator getMembers() {
        ArrayList<AttachmentsBySpaceNameSubView> children = new ArrayList<AttachmentsBySpaceNameSubView>();
        try {
            List docNames = this.xwikiContext.getWiki().getStore().searchDocumentsNames(", XWikiAttachment as attach where doc.id = attach.docId", 0, 0, this.xwikiContext);
            HashSet<String> spacesWithAttachments = new HashSet<String>();
            for (String docName : docNames) {
                int dot = docName.lastIndexOf(46);
                if (dot == -1) continue;
                spacesWithAttachments.add(docName.substring(0, dot));
            }
            for (String spaceName : spacesWithAttachments) {
                AttachmentsBySpaceNameSubView subView = new AttachmentsBySpaceNameSubView();
                subView.init(this, spaceName, "/" + spaceName);
                children.add(subView);
            }
        }
        catch (XWikiException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        catch (DavException e) {
            LOG.error("Unexpected Error : ", (Throwable)e);
        }
        return new DavResourceIteratorImpl(children);
    }

    public void addMember(DavResource resource, InputContext inputContext) throws DavException {
        throw new DavException(405);
    }

    public void removeMember(DavResource member) throws DavException {
        throw new DavException(405);
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, PROPFIND, LOCK, UNLOCK";
    }
}

