/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.webdav.resources.partial;

import com.xpn.xwiki.plugin.webdav.resources.XWikiDavResource;
import com.xpn.xwiki.plugin.webdav.resources.domain.DavTempFile;
import com.xpn.xwiki.plugin.webdav.utils.XWikiDavContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.SupportedLock;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDavResource
implements XWikiDavResource {
    protected String name;
    protected DavResourceLocator locator;
    protected XWikiDavResource parentResource;
    private XWikiDavContext context;

    @Override
    public void init(XWikiDavResource parent, String name, String relativePath) throws DavException {
        DavResourceLocator locator = parent.getLocator().getFactory().createResourceLocator(parent.getLocator().getPrefix(), parent.getLocator().getWorkspacePath(), parent.getLocator().getResourcePath() + relativePath);
        this.init(name, locator, parent.getContext());
        this.parentResource = parent;
    }

    @Override
    public void init(String name, DavResourceLocator locator, XWikiDavContext context) throws DavException {
        this.name = name;
        this.locator = locator;
        this.context = context;
        DavPropertySet propertySet = this.getVirtualProperties();
        if (propertySet.get(DavPropertyName.CREATIONDATE) == null) {
            String timeStamp = DavConstants.creationDateFormat.format(new Date());
            propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)timeStamp));
        }
        propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        if (this.isCollection()) {
            propertySet.add((DavProperty)new ResourceType(1));
            propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        } else {
            propertySet.add((DavProperty)new ResourceType(0));
            propertySet.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        propertySet.add((DavProperty)new LockDiscovery(this.getLock(Type.WRITE, Scope.EXCLUSIVE)));
        SupportedLock supportedLock = new SupportedLock();
        supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
        propertySet.add((DavProperty)supportedLock);
    }

    @Override
    public XWikiDavResource decode(String[] tokens, int next) throws DavException {
        if (!this.isCollection()) {
            throw new DavException(400);
        }
        String nextToken = tokens[next];
        boolean last = next == tokens.length - 1;
        DavTempFile resource = new DavTempFile();
        String method = this.getContext().getMethod();
        if (method != null && DavMethods.getMethodCode((String)method) == 9) {
            resource.setCollection();
        }
        resource.init(this, nextToken, "/" + nextToken);
        int index = this.getVirtualMembers().indexOf(resource);
        if (index != -1) {
            resource = (DavTempFile)this.getVirtualMembers().get(index);
            resource.init(this, nextToken, "/" + nextToken);
        }
        return last ? resource : resource.decode(tokens, next + 1);
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope);
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.getContext().getLockManager().getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock lock(LockInfo reqLockInfo) throws DavException {
        ActiveLock lock = null;
        if (!this.isLockable(reqLockInfo.getType(), reqLockInfo.getScope())) {
            throw new DavException(412);
        }
        lock = this.getContext().getLockManager().createLock(reqLockInfo, (DavResource)this);
        return lock;
    }

    public ActiveLock refreshLock(LockInfo reqLockInfo, String lockToken) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        ActiveLock lock = this.getLock(reqLockInfo.getType(), reqLockInfo.getScope());
        if (lock == null) {
            throw new DavException(412);
        }
        return this.getContext().getLockManager().refreshLock(reqLockInfo, lockToken, (DavResource)this);
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock != null && lock.isLockedByToken(lockToken)) {
            this.getContext().getLockManager().releaseLock(lockToken, (DavResource)this);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new DavException(501);
    }

    public DavPropertySet getProperties() {
        return this.getVirtualProperties();
    }

    public DavProperty getProperty(DavPropertyName name) {
        return this.getProperties().get(name);
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    public MultiStatusResponse alterProperties(DavPropertySet setProperties, DavPropertyNameSet removePropertyNames) throws DavException {
        this.getProperties().addAll(setProperties);
        DavPropertyNameIterator it = removePropertyNames.iterator();
        while (it.hasNext()) {
            this.removeProperty(it.nextPropertyName());
        }
        return this.createPropStat();
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        for (Object next : changeList) {
            if (next instanceof DavProperty) {
                DavProperty property = (DavProperty)next;
                this.setProperty(property);
                continue;
            }
            DavPropertyName propertyName = (DavPropertyName)next;
            this.removeProperty(propertyName);
        }
        return this.createPropStat();
    }

    private MultiStatusResponse createPropStat() {
        DavPropertyNameSet propertyNameSet = new DavPropertyNameSet();
        for (DavPropertyName propertyName : this.getPropertyNames()) {
            propertyNameSet.add(propertyName);
        }
        return new MultiStatusResponse((DavResource)this, propertyNameSet);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.getProperties().remove(propertyName);
    }

    public void setProperty(DavProperty property) throws DavException {
        this.getProperties().add(property);
    }

    public void addLockManager(LockManager lockmgr) {
        throw new UnsupportedOperationException();
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getComplianceClass() {
        return "1, 2";
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    }

    public DavResourceFactory getFactory() {
        return this.getContext().getResourceFactory();
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public DavSession getSession() {
        return this.getContext().getDavSession();
    }

    public DavResource getCollection() {
        return this.parentResource;
    }

    @Override
    public XWikiDavContext getContext() {
        return this.context;
    }

    @Override
    public List<XWikiDavResource> getVirtualMembers() {
        Map<String, List<XWikiDavResource>> vResourcesMap = this.getContext().getUserStorage().getResourcesMap();
        if (vResourcesMap.get(this.getResourcePath()) == null) {
            vResourcesMap.put(this.getResourcePath(), this.getInitMembers());
        }
        return vResourcesMap.get(this.getResourcePath());
    }

    @Override
    public DavPropertySet getVirtualProperties() {
        Map<String, DavPropertySet> vPropertiesMap = this.getContext().getUserStorage().getPropertiesMap();
        if (vPropertiesMap.get(this.getResourcePath()) == null) {
            vPropertiesMap.put(this.getResourcePath(), new DavPropertySet());
        }
        return vPropertiesMap.get(this.getResourcePath());
    }

    @Override
    public List<XWikiDavResource> getInitMembers() {
        return new ArrayList<XWikiDavResource>();
    }

    @Override
    public void clearCache() {
        Map<String, List<XWikiDavResource>> vResourcesMap = this.getContext().getUserStorage().getResourcesMap();
        Map<String, DavPropertySet> vPropertiesMap = this.getContext().getUserStorage().getPropertiesMap();
        vResourcesMap.remove(this.getResourcePath());
        vPropertiesMap.remove(this.getResourcePath());
    }

    public void addVirtualMember(DavResource resource, InputContext inputContext) throws DavException {
        XWikiDavResource davResource = (XWikiDavResource)resource;
        boolean isFile = inputContext.getInputStream() != null;
        long modificationTime = inputContext.getModificationTime();
        if (davResource instanceof DavTempFile) {
            DavTempFile tempFile = (DavTempFile)davResource;
            if (isFile) {
                byte[] data = null;
                data = this.getContext().getFileContentAsBytes(inputContext.getInputStream());
                tempFile.update(data, new Date(modificationTime));
            } else {
                tempFile.setModified(new Date(modificationTime));
            }
        }
        if (!this.getVirtualMembers().contains(davResource)) {
            this.getVirtualMembers().add(davResource);
        }
    }

    public void removeVirtualMember(DavResource member) throws DavException {
        XWikiDavResource davResource = (XWikiDavResource)member;
        if (!this.getVirtualMembers().contains(davResource)) {
            throw new DavException(404);
        }
        this.getVirtualMembers().remove(davResource);
        davResource.clearCache();
    }

    public boolean isTempResource(String resourceName) {
        return resourceName.startsWith(".") || resourceName.endsWith("~");
    }

    public int hashCode() {
        return this.getResourcePath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DavResource) {
            DavResource other = (DavResource)obj;
            return this.getResourcePath().equals(other.getResourcePath());
        }
        return false;
    }
}

