/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor.javascript;

import com.yahoo.platform.yui.compressor.javascript.Context;
import com.yahoo.platform.yui.compressor.javascript.DefaultErrorReporter;
import com.yahoo.platform.yui.compressor.javascript.ErrorReporter;
import java.util.Set;

public class CompilerEnvirons {
    private ErrorReporter errorReporter = DefaultErrorReporter.instance;
    private int languageVersion = 0;
    private boolean generateDebugInfo = true;
    private boolean useDynamicScope = false;
    private boolean reservedKeywordAsIdentifier = false;
    private boolean allowMemberExprAsFunctionName = false;
    private boolean xmlAvailable = true;
    private int optimizationLevel = 0;
    private boolean generatingSource = true;
    private boolean strictMode = false;
    private boolean warningAsError = false;
    private boolean generateObserverCount = false;
    Set<String> activationNames;

    public void initFromContext(Context cx) {
        this.setErrorReporter(cx.getErrorReporter());
        this.languageVersion = cx.getLanguageVersion();
        this.useDynamicScope = cx.compileFunctionsWithDynamicScopeFlag;
        this.generateDebugInfo = !cx.isGeneratingDebugChanged() || cx.isGeneratingDebug();
        this.reservedKeywordAsIdentifier = cx.hasFeature(3);
        this.allowMemberExprAsFunctionName = cx.hasFeature(2);
        this.strictMode = cx.hasFeature(11);
        this.warningAsError = cx.hasFeature(12);
        this.xmlAvailable = cx.hasFeature(6);
        this.optimizationLevel = cx.getOptimizationLevel();
        this.generatingSource = cx.isGeneratingSource();
        this.activationNames = cx.activationNames;
        this.generateObserverCount = cx.generateObserverCount;
    }

    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }

    public final int getLanguageVersion() {
        return this.languageVersion;
    }

    public void setLanguageVersion(int languageVersion) {
        Context.checkLanguageVersion(languageVersion);
        this.languageVersion = languageVersion;
    }

    public final boolean isGenerateDebugInfo() {
        return this.generateDebugInfo;
    }

    public void setGenerateDebugInfo(boolean flag) {
        this.generateDebugInfo = flag;
    }

    public final boolean isUseDynamicScope() {
        return this.useDynamicScope;
    }

    public final boolean isReservedKeywordAsIdentifier() {
        return this.reservedKeywordAsIdentifier;
    }

    public void setReservedKeywordAsIdentifier(boolean flag) {
        this.reservedKeywordAsIdentifier = flag;
    }

    public final boolean isAllowMemberExprAsFunctionName() {
        return this.allowMemberExprAsFunctionName;
    }

    public void setAllowMemberExprAsFunctionName(boolean flag) {
        this.allowMemberExprAsFunctionName = flag;
    }

    public final boolean isXmlAvailable() {
        return this.xmlAvailable;
    }

    public void setXmlAvailable(boolean flag) {
        this.xmlAvailable = flag;
    }

    public final int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int level) {
        Context.checkOptimizationLevel(level);
        this.optimizationLevel = level;
    }

    public final boolean isGeneratingSource() {
        return this.generatingSource;
    }

    public final boolean isStrictMode() {
        return this.strictMode;
    }

    public final boolean reportWarningAsError() {
        return this.warningAsError;
    }

    public void setGeneratingSource(boolean generatingSource) {
        this.generatingSource = generatingSource;
    }

    public boolean isGenerateObserverCount() {
        return this.generateObserverCount;
    }

    public void setGenerateObserverCount(boolean generateObserverCount) {
        this.generateObserverCount = generateObserverCount;
    }
}

