/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor.javascript.optimizer;

import com.yahoo.platform.yui.compressor.javascript.Kit;
import com.yahoo.platform.yui.compressor.javascript.Node;
import com.yahoo.platform.yui.compressor.javascript.NodeTransformer;
import com.yahoo.platform.yui.compressor.javascript.ObjArray;
import com.yahoo.platform.yui.compressor.javascript.ScriptOrFnNode;
import com.yahoo.platform.yui.compressor.javascript.optimizer.OptFunctionNode;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptTransformer
extends NodeTransformer {
    private Map<String, OptFunctionNode> possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(Map<String, OptFunctionNode> possibleDirectCalls, ObjArray directCallTargets) {
        this.possibleDirectCalls = possibleDirectCalls;
        this.directCallTargets = directCallTargets;
    }

    @Override
    protected void visitNew(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        super.visitNew(node, tree);
    }

    @Override
    protected void visitCall(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        super.visitCall(node, tree);
    }

    private void detectDirectCall(Node node, ScriptOrFnNode tree) {
        if (tree.getType() == 108) {
            Node left = node.getFirstChild();
            int argCount = 0;
            Node arg = left.getNext();
            while (arg != null) {
                arg = arg.getNext();
                ++argCount;
            }
            if (argCount == 0) {
                OptFunctionNode.get((ScriptOrFnNode)tree).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode ofn;
                String targetName = null;
                if (left.getType() == 39) {
                    targetName = left.getString();
                } else if (left.getType() == 33) {
                    targetName = left.getFirstChild().getNext().getString();
                } else if (left.getType() == 34) {
                    throw Kit.codeBug();
                }
                if (targetName != null && (ofn = this.possibleDirectCalls.get(targetName)) != null && argCount == ofn.fnode.getParamCount() && !ofn.fnode.requiresActivation() && argCount <= 32) {
                    node.putProp(9, ofn);
                    if (!ofn.isTargetOfDirectCall()) {
                        int index = this.directCallTargets.size();
                        this.directCallTargets.add(ofn);
                        ofn.setDirectTargetIndex(index);
                    }
                }
            }
        }
    }
}

