/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.ArchiveWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarWriterImpl
extends ArchiveWriter {
    private JarOutputStream jos;

    public JarWriterImpl(File archive, Manifest man) throws IOException {
        super(man);
        this.jos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(archive)), man);
    }

    @Override
    public void setComment(String comment) {
        this.jos.setComment(comment);
    }

    @Override
    public void addDirectory(String path) throws IOException {
        JarWriterImpl.ensureValid(path);
        JarWriterImpl.newEntry(this.jos, JarWriterImpl.ensureDirName(path));
        this.jos.closeEntry();
    }

    @Override
    public void addFile(String path, byte[] data) throws IOException {
        JarWriterImpl.ensureValid(path);
        JarWriterImpl.newEntry(this.jos, path);
        this.jos.write(data);
        this.jos.closeEntry();
    }

    @Override
    public void close() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.close();
            this.jos = null;
        }
    }

    private static void newEntry(JarOutputStream jos, String path) throws IOException {
        jos.putNextEntry(new JarEntry(path));
    }

    private static String ensureDirName(String path) {
        return path.endsWith("/") ? path : path + '/';
    }

    private static void ensureValid(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
    }
}

