/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.InnerClassesInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InnerClassesAttrInfo
extends AttrInfo {
    private int u2numberOfClasses;
    private InnerClassesInfo[] classes;

    protected InnerClassesAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "InnerClasses";
    }

    protected InnerClassesInfo[] getInfo() {
        return this.classes;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.classes.length; ++i) {
            this.classes[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2numberOfClasses = din.readUnsignedShort();
        this.classes = new InnerClassesInfo[this.u2numberOfClasses];
        for (int i = 0; i < this.u2numberOfClasses; ++i) {
            this.classes[i] = InnerClassesInfo.create(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2numberOfClasses);
        for (int i = 0; i < this.u2numberOfClasses; ++i) {
            this.classes[i].write(dout);
        }
    }
}

