/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.LocalVariableTypeInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LocalVariableTypeTableAttrInfo
extends AttrInfo {
    private int u2localVariableTypeTableLength;
    private LocalVariableTypeInfo[] localVariableTypeTable;

    protected LocalVariableTypeTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LocalVariableTypeTable";
    }

    protected LocalVariableTypeInfo[] getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public void setLocalVariableTypeTable(LocalVariableTypeInfo[] lvts) {
        this.localVariableTypeTable = lvts;
        this.u2localVariableTypeTableLength = lvts.length;
        this.u4attrLength = 2 + 10 * this.u2localVariableTypeTableLength;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.localVariableTypeTable.length; ++i) {
            this.localVariableTypeTable[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2localVariableTypeTableLength = din.readUnsignedShort();
        this.localVariableTypeTable = new LocalVariableTypeInfo[this.u2localVariableTypeTableLength];
        for (int i = 0; i < this.u2localVariableTypeTableLength; ++i) {
            this.localVariableTypeTable[i] = LocalVariableTypeInfo.create(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2localVariableTypeTableLength);
        for (int i = 0; i < this.u2localVariableTypeTableLength; ++i) {
            this.localVariableTypeTable[i].write(dout);
        }
    }
}

