/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AnnotationInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TypeAnnotationInfo
extends AnnotationInfo {
    private int u1TargetType;
    private int u1TypeParameterIndex;
    private int u2SupertypeIndex;
    private int u1TypeBoundIndex;
    private int u1FormalParameterIndex;
    private int u2ThrowsTypeIndex;
    private int u2ExceptionTableIndex;
    private int u2Offset;
    private int u1TypeArgumentIndex;
    private LocalvarTarget localvarTarget;
    private TypePath targetPath;

    TypeAnnotationInfo() {
    }

    public static TypeAnnotationInfo create(DataInput din) throws IOException {
        TypeAnnotationInfo an = new TypeAnnotationInfo();
        an.read(din);
        return an;
    }

    @Override
    void read(DataInput din) throws IOException {
        this.u1TargetType = din.readUnsignedByte();
        switch (this.u1TargetType) {
            case 0: 
            case 1: {
                this.u1TypeParameterIndex = din.readUnsignedByte();
                break;
            }
            case 16: {
                this.u2SupertypeIndex = din.readUnsignedShort();
                break;
            }
            case 17: 
            case 18: {
                this.u1TypeParameterIndex = din.readUnsignedByte();
                this.u1TypeBoundIndex = din.readUnsignedByte();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                this.u1FormalParameterIndex = din.readUnsignedByte();
                break;
            }
            case 23: {
                this.u2ThrowsTypeIndex = din.readUnsignedShort();
                break;
            }
            case 64: 
            case 65: {
                this.localvarTarget = new LocalvarTarget();
                this.localvarTarget.readInfo(din);
                break;
            }
            case 66: {
                this.u2ExceptionTableIndex = din.readUnsignedShort();
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.u2Offset = din.readUnsignedShort();
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                this.u2Offset = din.readUnsignedShort();
                this.u1TypeArgumentIndex = din.readUnsignedByte();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown annotation target type: 0x" + Integer.toHexString(this.u1TargetType) + "");
            }
        }
        this.targetPath = new TypePath();
        this.targetPath.readInfo(din);
        super.read(din);
    }

    @Override
    public void write(DataOutput dout) throws IOException {
        dout.writeByte(this.u1TargetType);
        switch (this.u1TargetType) {
            case 0: 
            case 1: {
                dout.writeByte(this.u1TypeParameterIndex);
                break;
            }
            case 16: {
                dout.writeShort(this.u2SupertypeIndex);
                break;
            }
            case 17: 
            case 18: {
                dout.writeByte(this.u1TypeParameterIndex);
                dout.writeByte(this.u1TypeBoundIndex);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                dout.writeByte(this.u1FormalParameterIndex);
                break;
            }
            case 23: {
                dout.writeShort(this.u2ThrowsTypeIndex);
                break;
            }
            case 64: 
            case 65: {
                this.localvarTarget.writeInfo(dout);
                break;
            }
            case 66: {
                dout.writeShort(this.u2ExceptionTableIndex);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                dout.writeShort(this.u2Offset);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                dout.writeShort(this.u2Offset);
                dout.writeByte(this.u1TypeArgumentIndex);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown annotation target type: 0x" + Integer.toHexString(this.u1TargetType) + "");
            }
        }
        this.targetPath.writeInfo(dout);
        super.write(dout);
    }

    static class TypePath {
        private int u1PathLength;
        private PathEntry[] entries;

        TypePath() {
        }

        protected void readInfo(DataInput din) throws IOException {
            this.u1PathLength = din.readUnsignedByte();
            this.entries = new PathEntry[this.u1PathLength];
            for (int i = 0; i < this.u1PathLength; ++i) {
                this.entries[i] = PathEntry.create(din);
            }
        }

        public void writeInfo(DataOutput dout) throws IOException {
            dout.writeByte(this.u1PathLength);
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i].write(dout);
            }
        }

        static class PathEntry {
            private int u1PathKind;
            private int u1TypeArgumentIndex;

            PathEntry() {
            }

            public static PathEntry create(DataInput din) throws IOException {
                PathEntry lvi = new PathEntry();
                lvi.read(din);
                return lvi;
            }

            private void read(DataInput din) throws IOException {
                this.u1PathKind = din.readUnsignedByte();
                this.u1TypeArgumentIndex = din.readUnsignedByte();
            }

            public void write(DataOutput dout) throws IOException {
                dout.writeByte(this.u1PathKind);
                dout.writeByte(this.u1TypeArgumentIndex);
            }
        }
    }

    static class LocalvarTarget {
        private int u2TableLength;
        private LocalVarTargetVariableInfo[] table;

        LocalvarTarget() {
        }

        protected void readInfo(DataInput din) throws IOException {
            this.u2TableLength = din.readUnsignedShort();
            this.table = new LocalVarTargetVariableInfo[this.u2TableLength];
            for (int i = 0; i < this.u2TableLength; ++i) {
                this.table[i] = LocalVarTargetVariableInfo.create(din);
            }
        }

        public void writeInfo(DataOutput dout) throws IOException {
            dout.writeShort(this.u2TableLength);
            for (int i = 0; i < this.u2TableLength; ++i) {
                this.table[i].write(dout);
            }
        }

        static class LocalVarTargetVariableInfo {
            private int u2startPc;
            private int u2length;
            private int u2index;

            LocalVarTargetVariableInfo() {
            }

            public static LocalVarTargetVariableInfo create(DataInput din) throws IOException {
                LocalVarTargetVariableInfo lvi = new LocalVarTargetVariableInfo();
                lvi.read(din);
                return lvi;
            }

            private void read(DataInput din) throws IOException {
                this.u2startPc = din.readUnsignedShort();
                this.u2length = din.readUnsignedShort();
                this.u2index = din.readUnsignedShort();
            }

            public void write(DataOutput dout) throws IOException {
                dout.writeShort(this.u2startPc);
                dout.writeShort(this.u2length);
                dout.writeShort(this.u2index);
            }
        }
    }
}

