/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariResultSetProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class StatementProxy
implements IHikariStatementProxy,
Statement {
    protected static ProxyFactory PROXY_FACTORY;
    @HikariInject
    protected IHikariConnectionProxy _connection;
    @HikariInject
    protected boolean _isClosed;
    protected final Statement delegate;

    protected StatementProxy(IHikariConnectionProxy connection, Statement statement) {
        this._connection = connection;
        this.delegate = statement;
    }

    @Override
    @HikariInject
    public void _setConnectionProxy(IHikariConnectionProxy connection) {
        this._connection = connection;
    }

    @Override
    @HikariInject
    public IHikariConnectionProxy _getConnectionProxy() {
        return this._connection;
    }

    @Override
    @HikariInject
    public SQLException _checkException(SQLException e) {
        return this._connection._checkException(e);
    }

    @Override
    @HikariInject
    public void _releaseResultSet(IHikariResultSetProxy resultSet) {
    }

    @HikariInject
    protected <T extends ResultSet> T _trackResultSet(T resultSet) {
        if (resultSet != null) {
            ((IHikariResultSetProxy)((Object)resultSet))._setProxyStatement(this);
        }
        return resultSet;
    }

    @Override
    @HikariOverride
    public void close() throws SQLException {
        if (this._isClosed) {
            return;
        }
        this._isClosed = true;
        this._connection._unregisterStatement(this);
        try {
            this.__close();
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this._trackResultSet(this.__executeQuery(sql));
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public ResultSet getResultSet() throws SQLException {
        try {
            return this._trackResultSet(this.__getResultSet());
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    @HikariOverride
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this._trackResultSet(this.__getGeneratedKeys());
        }
        catch (SQLException e) {
            throw this._checkException(e);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this._connection);
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    public void __close() throws SQLException {
        if (this.delegate.isClosed()) {
            return;
        }
        this.delegate.close();
    }

    public ResultSet __executeQuery(String sql) throws SQLException {
        return this.wrapResultSet(this.delegate.executeQuery(sql));
    }

    public ResultSet __getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.delegate.getGeneratedKeys());
    }

    public ResultSet __getResultSet() throws SQLException {
        return this.wrapResultSet(this.delegate.getResultSet());
    }

    protected ResultSet wrapResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = PROXY_FACTORY.getProxyResultSet(this, resultSet);
        }
        return resultSet;
    }

    static {
        StatementProxy.__static();
    }
}

