/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.crypto;

import com.zebrunner.carina.crypto.Algorithm;
import com.zebrunner.carina.crypto.CryptoTool;
import com.zebrunner.carina.crypto.DecryptionException;
import com.zebrunner.carina.crypto.EncryptionException;
import com.zebrunner.carina.crypto.SecretKeyManager;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

class CryptoToolImpl
implements CryptoTool {
    private Cipher cipher;
    private final Key key;

    public CryptoToolImpl(Algorithm algorithm, Key key) {
        this.initCipher(algorithm);
        this.key = key;
    }

    public CryptoToolImpl(Algorithm algorithm, String key) {
        this.initCipher(algorithm);
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("The key must be passed!");
        }
        this.key = SecretKeyManager.getKeyFromString(algorithm, key);
    }

    private void initCipher(Algorithm algorithm) {
        try {
            this.cipher = Cipher.getInstance(algorithm.getName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm " + algorithm.getName() + " is not supported", e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException("Padding of algorithm " + algorithm.getName() + " is not supported", e);
        }
    }

    @Override
    public String encrypt(String str) {
        try {
            this.cipher.init(1, this.key);
            return new String(Base64.encodeBase64((byte[])this.cipher.doFinal(str.getBytes())));
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new EncryptionException("Error while encrypting, check your crypto key or length of string! Try to choose algorithm with bigger key size", e);
        }
    }

    @Override
    public String decrypt(String str) {
        try {
            this.cipher.init(2, this.key);
            return new String(this.cipher.doFinal(Base64.decodeBase64((byte[])str.getBytes())));
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new DecryptionException("Error while decrypting, check your crypto key! ", e);
        }
    }

    @Override
    public String encrypt(String str, String pattern) {
        return this.encrypt(str, pattern, "%s");
    }

    @Override
    public String decrypt(String str, String pattern) {
        return this.decrypt(str, pattern, "%s");
    }

    @Override
    public String encrypt(String str, String pattern, String wrapper) {
        this.validatePattern(pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        while (matcher.find()) {
            String dataToEncrypt = this.getDataGroup(matcher.group(), pattern);
            if (dataToEncrypt.isEmpty()) continue;
            str = StringUtils.replace((String)str, (String)matcher.group(), (String)String.format(wrapper, this.encrypt(dataToEncrypt)));
        }
        return str;
    }

    @Override
    public String decrypt(String str, String pattern, String wrapper) {
        this.validatePattern(pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        while (matcher.find()) {
            String dataToDecrypt = this.getDataGroup(matcher.group(), pattern);
            if (dataToDecrypt.isEmpty()) continue;
            str = StringUtils.replace((String)str, (String)matcher.group(), (String)String.format(wrapper, this.decrypt(dataToDecrypt)));
        }
        return str;
    }

    @Override
    public boolean hasMatch(String str, String pattern) {
        this.validatePattern(pattern);
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        return matcher.find();
    }

    private String getDataGroup(String str, String pattern) {
        Matcher matcher = Pattern.compile(pattern).matcher(str);
        return matcher.find() ? matcher.group("data") : "";
    }

    private void validatePattern(String pattern) {
        if (!pattern.contains("(?<data>")) {
            throw new IllegalArgumentException("There are no data group in pattern: " + pattern);
        }
    }
}

