/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.dataprovider.core.impl;

import com.zebrunner.carina.dataprovider.DataProviderParameterGenerator;
import com.zebrunner.carina.dataprovider.parser.DSBean;
import com.zebrunner.carina.utils.parser.xls.AbstractTable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public abstract class BaseDataProvider {
    protected Map<String, String> tuidMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, String> testColumnNamesMap = Collections.synchronizedMap(new HashMap());

    public abstract Object[][] getDataProvider(Annotation var1, ITestContext var2, ITestNGMethod var3);

    protected void addValueToMap(Map<String, String> map, String hashCode, String value) {
        if (!value.isEmpty()) {
            map.put(hashCode, value);
        }
    }

    public Object[][] createGroupedDataProvider(List<List<Map<String, String>>> groupedList, DSBean dsBean, ITestNGMethod testMethod) {
        Object[][] dataProvider = this.declareDataProviderArray(groupedList, dsBean);
        if (dsBean.getArgs().isEmpty()) {
            this.fillArgsAsMap(dataProvider, groupedList, dsBean);
        } else {
            this.fillArgsAsGroupedMap(dataProvider, groupedList, dsBean);
        }
        this.configureTestNamingVarsForGroupedProvider(dataProvider, dsBean, groupedList, testMethod);
        return dataProvider;
    }

    public Object[][] createDataProvider(AbstractTable table, DSBean dsBean, ITestNGMethod testMethod) {
        Object[][] dataProvider = this.declareDataProviderArray(table.getDataRows(), dsBean);
        if (dsBean.isArgsToMap()) {
            this.fillArgsAsMap(dataProvider, table.getDataRows(), dsBean);
        } else {
            this.fillArgsAsArray(dataProvider, table, dsBean);
        }
        this.configureTestNamingVars(dataProvider, dsBean, table, testMethod);
        return dataProvider;
    }

    private void fillArgsAsGroupedMap(Object[][] dataProvider, List<List<Map<String, String>>> groupedList, DSBean dsBean) {
        List<String> argsToPass = dsBean.getArgs();
        for (int rowIndex = 0; rowIndex < groupedList.size(); ++rowIndex) {
            ArrayList listToPass = new ArrayList();
            for (Map<String, String> groupedMap : groupedList.get(rowIndex)) {
                HashMap<String, String> mapToPass = new HashMap<String, String>();
                for (String argName : argsToPass) {
                    mapToPass.put(argName, groupedMap.get(argName));
                }
                listToPass.add(mapToPass);
            }
            dataProvider[rowIndex][0] = listToPass;
            for (int staticArgsColumn = 0; staticArgsColumn < dsBean.getStaticArgs().size(); ++staticArgsColumn) {
                String staticArgName = dsBean.getStaticArgs().get(staticArgsColumn);
                dataProvider[rowIndex][staticArgsColumn + 1] = BaseDataProvider.getStaticParam(staticArgName, dsBean);
            }
        }
    }

    private void fillArgsAsMap(Object[][] dataProvider, List<?> dataRows, DSBean dsBean) {
        for (int rowIndex = 0; rowIndex < dataProvider.length; ++rowIndex) {
            dataProvider[rowIndex][0] = dataRows.get(rowIndex);
            for (int staticArgsColumn = 0; staticArgsColumn < dsBean.getStaticArgs().size(); ++staticArgsColumn) {
                String staticArgName = dsBean.getStaticArgs().get(staticArgsColumn);
                dataProvider[rowIndex][staticArgsColumn + 1] = BaseDataProvider.getStaticParam(staticArgName, dsBean);
            }
        }
    }

    private void fillArgsAsArray(Object[][] dataProvider, AbstractTable table, DSBean dsBean) {
        for (int rowIndex = 0; rowIndex < dataProvider.length; ++rowIndex) {
            Map<String, String> row = table.getDataRows().get(rowIndex);
            for (int argsColumn = 0; argsColumn < dsBean.getArgs().size(); ++argsColumn) {
                dataProvider[rowIndex][argsColumn] = row.get(dsBean.getArgs().get(argsColumn));
            }
            for (int staticArgsColumn = 0; staticArgsColumn < dsBean.getStaticArgs().size(); ++staticArgsColumn) {
                String staticArgName = dsBean.getStaticArgs().get(staticArgsColumn);
                dataProvider[rowIndex][staticArgsColumn + dsBean.getArgs().size()] = BaseDataProvider.getStaticParam(staticArgName, dsBean);
            }
        }
    }

    private Object[][] declareDataProviderArray(List<?> dataRows, DSBean dsBean) {
        int numberOfRowsToExecute = dataRows.size();
        int numberOfArgsInTest = dsBean.isArgsToMap() ? 1 + dsBean.getStaticArgs().size() : dsBean.getArgs().size() + dsBean.getStaticArgs().size();
        return new Object[numberOfRowsToExecute][numberOfArgsInTest];
    }

    private void configureTestNamingVars(Object[][] dataProvider, DSBean dsBean, AbstractTable table, ITestNGMethod testNGMethod) {
        for (int rowIndex = 0; rowIndex < dataProvider.length; ++rowIndex) {
            Map<String, String> row = table.getDataRows().get(rowIndex);
            String rowHash = DataProviderParameterGenerator.hash(dataProvider[rowIndex], testNGMethod);
            this.addValueToMap(this.tuidMap, rowHash, this.getValueFromRow(row, dsBean.getUidArgs()));
            this.addValueToMap(this.testColumnNamesMap, rowHash, this.getValueFromRow(row, List.of(dsBean.getTestMethodColumn())));
        }
    }

    private void configureTestNamingVarsForGroupedProvider(Object[][] dataProvider, DSBean dsBean, List<List<Map<String, String>>> groupedList, ITestNGMethod testNGMethod) {
        for (int rowIndex = 0; rowIndex < dataProvider.length; ++rowIndex) {
            String rowHash = DataProviderParameterGenerator.hash(dataProvider[rowIndex], testNGMethod);
            String testUid = this.getValueFromGroupList(rowIndex, groupedList, dsBean.getUidArgs());
            this.addValueToMap(this.tuidMap, rowHash, testUid);
            String testName = this.getValueFromGroupList(rowIndex, groupedList, List.of(dsBean.getTestMethodColumn()));
            testName = testName.split(",")[0];
            this.addValueToMap(this.testColumnNamesMap, rowHash, testName);
        }
    }

    private String getValueFromGroupList(int rowIndex, List<List<Map<String, String>>> groupedList, List<String> columnNames) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        List<Map<String, String>> dataRowList = groupedList.get(rowIndex);
        for (Map<String, String> dataMap : dataRowList) {
            values.add(this.getValueFromRow(dataMap, columnNames));
        }
        StringBuilder valueRes = new StringBuilder(String.join((CharSequence)",", values));
        if (valueRes.indexOf(",") != -1) {
            valueRes.replace(valueRes.length() - 1, valueRes.length(), "");
        }
        return valueRes.toString();
    }

    private String getValueFromRow(Map<String, String> row, List<String> columnNames) {
        StringBuilder valueRes = new StringBuilder();
        for (String key : columnNames) {
            String value;
            if (key.isEmpty() || !row.containsKey(key) || (value = row.get(key)) == null || value.isEmpty()) continue;
            valueRes.append(value);
            valueRes.append(",");
        }
        if (valueRes.indexOf(",") != -1) {
            valueRes.replace(valueRes.length() - 1, valueRes.length(), "");
        }
        return valueRes.toString();
    }

    protected static Object getStaticParam(String name, DSBean dsBean) {
        Object param = DataProviderParameterGenerator.process(dsBean.getTestParams().get(name));
        if (param == null) {
            throw new RuntimeException("Cant find parameter " + name + " in suite");
        }
        return param;
    }

    public Map<String, String> getTestColumnNamesMap() {
        return this.testColumnNamesMap;
    }

    public Map<String, String> getTuidMap() {
        return this.tuidMap;
    }
}

