/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.dataprovider.parser.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.zebrunner.carina.dataprovider.parser.DSBean;
import com.zebrunner.carina.dataprovider.parser.csv.CSVTable;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private CSVParser() {
    }

    public static CSVTable parseCsvFile(DSBean dsBean, char separator, char quote) {
        CSVTable csvTable = new CSVTable(dsBean.getExecuteColumn(), dsBean.getExecuteValue());
        List<String[]> data = CSVParser.readData(dsBean, separator, quote);
        if (data.isEmpty()) {
            throw new RuntimeException("Unable to retrieve data from CSV DataProvider! Verify separator and quote settings.");
        }
        csvTable.setHeaders(Arrays.asList(data.get(0)));
        CSVParser.mapData(csvTable, data);
        return csvTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String[]> readData(DSBean dsBean, char separator, char quote) {
        CSVReader reader = null;
        List<Object> list = new ArrayList<String[]>();
        try {
            String csvFile = ClassLoader.getSystemResource(dsBean.getDsFile()).getFile();
            try (FileReader fileReader = new FileReader(csvFile);){
                reader = new CSVReader((Reader)fileReader, separator, quote);
                list = reader.readAll();
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to read data from CSV DataProvider", (Throwable)e);
        }
        finally {
            try {
                assert (reader != null);
                reader.close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to close CSV Reader", (Throwable)e);
            }
        }
        return list;
    }

    private static void mapData(CSVTable table, List<String[]> data) {
        for (int i = 1; i < data.size(); ++i) {
            table.addDataRow(List.of(data.get(i)));
        }
    }
}

