/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XLSCache {
    private static final Map<String, Workbook> xlsCache = new HashMap<String, Workbook>();

    private XLSCache() {
    }

    public static synchronized Workbook getWorkbook(String xlsPath) {
        if (!xlsCache.containsKey(xlsPath)) {
            Workbook wb;
            try (InputStream is = ClassLoader.getSystemResourceAsStream(xlsPath);){
                wb = WorkbookFactory.create((InputStream)is);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't read xls: " + xlsPath, e);
            }
            xlsCache.put(xlsPath, wb);
        }
        return xlsCache.get(xlsPath);
    }

    public static synchronized String getWorkbookPath(Workbook book) {
        for (Map.Entry<String, Workbook> entry : xlsCache.entrySet()) {
            if (entry.getValue() != book) continue;
            return entry.getKey();
        }
        return null;
    }
}

