/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;

public final class StringGenerator {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    private static final String GENERATE = "$generate";
    private static final Random RANDOM = new Random();

    private StringGenerator() {
    }

    public static String generateWord(int keySize) {
        StringBuilder result = new StringBuilder();
        String base = StringGenerator.generateBase(keySize);
        int position = RANDOM.nextInt(ALPHABET.length() - 1);
        int sign = -1;
        for (int i = 0; i < keySize; ++i) {
            int step = Integer.parseInt(base.substring(i, i + 1)) * sign;
            position = position + step > 0 && position + step < ALPHABET.length() - 1 ? (position += step) : (position -= step);
            result.append(ALPHABET.charAt(position));
            sign *= -1;
        }
        return result.toString();
    }

    public static String generateNumeric(int keySize) {
        return RandomStringUtils.randomNumeric((int)keySize);
    }

    public static String generateWordAN(int keySize) {
        return RandomStringUtils.randomAlphanumeric((int)keySize);
    }

    private static String generateBase(int keySize) {
        StringBuilder base = new StringBuilder();
        for (int i = 0; i < keySize; ++i) {
            base.append(RANDOM.nextInt(9));
        }
        return base.toString();
    }

    public static void generateInputParameters(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].toString().contains(GENERATE)) continue;
            Object newLine = params[i].toString();
            int size = Integer.parseInt(((String)newLine).split(":")[1]);
            newLine = ((String)newLine).substring(0, ((String)newLine).indexOf(GENERATE));
            params[i] = newLine = (String)newLine + StringGenerator.generateWord(size);
        }
    }

    public static String getUniqueItemName() {
        return "qatest-" + System.nanoTime();
    }

    public static String generateEmail() {
        return StringGenerator.generateWord(10) + "@gmail.com";
    }
}

