/*
 * Decompiled with CFR 0.152.
 */
package com.zebrunner.carina.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private ZipManager() {
    }

    public static void unzip(String zip, String extractTo) {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    Path path = Path.of(extractTo, entry.getName());
                    File folder = path.toFile();
                    boolean isCreated = folder.mkdir();
                    if (isCreated) continue;
                    throw new UncheckedIOException(new IOException("Folder not created: " + folder.getAbsolutePath()));
                }
                InputStream is = zipFile.getInputStream(entry);
                try (FileOutputStream fos = new FileOutputStream(Path.of(extractTo, entry.getName()).toFile());
                     BufferedOutputStream bos = new BufferedOutputStream(fos);){
                    ZipManager.copyInputStream(is, bos);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IO exception for unzip operation!", (Throwable)e);
        }
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        if (in == null) {
            return;
        }
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

