/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.IBootstrapButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.IMarkupSourcingStrategy;
import org.apache.wicket.markup.html.panel.PanelMarkupSourcingStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class BootstrapBookmarkablePageLink<T>
extends BookmarkablePageLink<T>
implements IBootstrapButton<BootstrapBookmarkablePageLink<T>>,
Activatable {
    private final Component label;
    private final Icon icon;
    private final ButtonBehavior buttonBehavior;
    private final Component splitter;

    public <P extends Page> BootstrapBookmarkablePageLink(String componentId, Class<P> pageClass, Buttons.Type type) {
        this(componentId, pageClass, new PageParameters(), type);
    }

    public <P extends Page> BootstrapBookmarkablePageLink(String componentId, Class<P> pageClass, PageParameters parameters, Buttons.Type type) {
        super(componentId, pageClass, parameters);
        Behavior[] behaviorArray = new Behavior[1];
        this.buttonBehavior = new ButtonBehavior(type, Buttons.Size.Medium);
        behaviorArray[0] = this.buttonBehavior;
        this.add(behaviorArray);
        Component[] componentArray = new Component[1];
        this.icon = this.newIcon("icon");
        componentArray[0] = this.icon;
        this.add(componentArray);
        this.splitter = this.newSplitter("splitter");
        this.add(new Component[]{this.splitter});
        this.label = this.newLabel("label");
        this.add(new Component[]{this.label});
    }

    protected Icon newIcon(String markupId) {
        return new Icon(markupId, (IconType)null);
    }

    protected Component newLabel(String markupId) {
        return new Label(markupId, (IModel)new Model((Serializable)((Object)""))).setRenderBodyOnly(true);
    }

    protected Component newSplitter(String markupId) {
        return new WebMarkupContainer(markupId).setRenderBodyOnly(true).setEscapeModelStrings(false);
    }

    protected final IMarkupSourcingStrategy newMarkupSourcingStrategy() {
        return new PanelMarkupSourcingStrategy(true);
    }

    @Override
    public BootstrapBookmarkablePageLink<T> setSize(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    @Override
    public BootstrapBookmarkablePageLink<T> setType(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }

    public BootstrapBookmarkablePageLink<T> setLabel(IModel<?> label) {
        this.label.setDefaultModel(label);
        return this;
    }

    public BootstrapBookmarkablePageLink<T> setIconType(IconType iconType) {
        this.icon.setType(iconType);
        return this;
    }

    protected void onConfigure() {
        super.onConfigure();
        this.splitter.setVisible(this.icon.hasIconType() && !Strings.isEmpty((CharSequence)this.label.getDefaultModelObjectAsString()));
    }

    @Override
    public boolean isActive(Component button) {
        Args.notNull((Object)button, (String)"button");
        return button.getPage().getClass().equals(this.getPageClass());
    }
}

