/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import com.google.common.base.Strings;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.core.util.CssClassNames;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ButtonBehavior
extends BootstrapBaseBehavior {
    private final IModel<Buttons.Type> buttonType;
    private final IModel<Buttons.Size> buttonSize;
    private final IModel<String> block;
    private final ICssClassNameProvider blockProvider;

    public ButtonBehavior() {
        this(Buttons.Type.Default, Buttons.Size.Medium);
    }

    public ButtonBehavior(Buttons.Size size) {
        this(Buttons.Type.Default, size);
    }

    public ButtonBehavior(Buttons.Type type) {
        this(type, Buttons.Size.Medium);
    }

    public ButtonBehavior(Buttons.Type type, Buttons.Size size) {
        this((IModel<Buttons.Type>)Model.of((Serializable)((Object)type)), (IModel<Buttons.Size>)Model.of((Serializable)((Object)size)));
    }

    public ButtonBehavior(IModel<Buttons.Type> buttonType, IModel<Buttons.Size> buttonSize) {
        this.buttonType = buttonType;
        this.buttonSize = buttonSize;
        this.block = Model.of((Serializable)((Object)""));
        this.blockProvider = CssClassNames.newProvider(this.block);
    }

    public Buttons.Size getSize() {
        return (Buttons.Size)this.buttonSize.getObject();
    }

    public Buttons.Type getType() {
        return (Buttons.Type)this.buttonType.getObject();
    }

    public boolean isBlock() {
        return !Strings.isNullOrEmpty((String)((String)this.block.getObject()));
    }

    public final ButtonBehavior setBlock(boolean block) {
        this.block.setObject((Object)(block ? "btn-block" : ""));
        return this;
    }

    public final ButtonBehavior setType(Buttons.Type type) {
        this.buttonType.setObject((Object)type);
        return this;
    }

    public final ButtonBehavior setSize(Buttons.Size size) {
        this.buttonSize.setObject((Object)size);
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Buttons.fixDisabledState(component, tag);
        Components.assertTag(component, tag, "a", "button", "input");
        if (!Buttons.Type.Menu.equals(this.getType())) {
            Buttons.onComponentTag(component, tag, (ICssClassNameProvider)this.buttonSize.getObject(), (ICssClassNameProvider)this.buttonType.getObject(), this.blockProvider);
        }
    }
}

