/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.ModalCloseButton;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class Modal<T>
extends GenericPanel<T> {
    public static final String BUTTON_MARKUP_ID = "button";
    private final WebMarkupContainer header;
    private boolean show = false;
    private boolean fadein = true;
    private boolean keyboard = true;
    private boolean closeOnEscapeKey = true;
    private Backdrop backdrop = Backdrop.TRUE;
    private final IModel<Boolean> disableEnforceFocus = Model.of((Serializable)Boolean.valueOf(false));
    private final Label headerLabel;
    private final List<Component> buttons = new ArrayList<Component>();
    private final WebMarkupContainer footer;
    private final IModel<Boolean> useCloseHandler = Model.of((Serializable)Boolean.valueOf(false));
    private final AjaxEventBehavior closeBehavior;
    private Size size = Size.Default;

    public Modal(String markupId) {
        this(markupId, null);
    }

    public Modal(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.setOutputMarkupPlaceholderTag(true);
        WebMarkupContainer dialog = this.createDialog("dialog");
        this.footer = new WebMarkupContainer("footer");
        this.header = new WebMarkupContainer("header");
        Component[] componentArray = new Component[1];
        this.headerLabel = new Label("header-label", "");
        componentArray[0] = this.headerLabel;
        this.header.add(componentArray);
        this.headerLabel.setOutputMarkupId(true);
        this.footer.add(new Component[]{new ListView<Component>("buttons", this.buttons){

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
        this.closeBehavior = new AjaxEventBehavior("hidden.bs.modal"){

            protected void onEvent(AjaxRequestTarget target) {
                Modal.this.handleCloseEvent(target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
            }
        };
        this.add(new Component[]{dialog});
        dialog.add(new Component[]{this.header, this.footer});
        BootstrapResourcesBehavior.addTo((Component)this);
    }

    protected WebMarkupContainer createDialog(String id) {
        return new TransparentWebMarkupContainer(id){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Attributes.removeClass(tag, Size.Large.cssClassName(), Size.Small.cssClassName());
                switch (Modal.this.size) {
                    case Large: {
                        Attributes.addClass(tag, Size.Large.cssClassName());
                        break;
                    }
                    case Small: {
                        Attributes.addClass(tag, Size.Small.cssClassName());
                        break;
                    }
                }
            }
        };
    }

    public Modal size(Size size) {
        this.size = size;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "modal");
        if (this.useFadein()) {
            Attributes.addClass(tag, "fade");
        } else {
            Attributes.removeClass(tag, "fade");
        }
        if (this.closeOnEscapeKey) {
            Attributes.set(tag, "tabindex", "-1");
        }
        if (this.backdrop != Backdrop.TRUE) {
            Attributes.set(tag, "data-backdrop", this.backdrop.name().toLowerCase());
        }
        Attributes.set(tag, "role", "dialog");
        Attributes.set(tag, "aria-labelledby", this.headerLabel.getMarkupId());
        Attributes.set(tag, "aria-hidden", "true");
    }

    protected void onClose(AjaxRequestTarget target) {
    }

    public Modal<T> header(IModel<String> label) {
        this.headerLabel.setDefaultModel(label);
        this.setHeaderVisible(true);
        return this;
    }

    public Modal<T> header(IModel<String> label, boolean escapeMarkup) {
        this.headerLabel.setDefaultModel(label);
        this.headerLabel.setEscapeModelStrings(escapeMarkup);
        return this;
    }

    public Modal<T> setFooterVisible(boolean visible) {
        this.footer.setVisible(visible);
        return this;
    }

    public Modal<T> setHeaderVisible(boolean visible) {
        this.header.setVisible(visible);
        return this;
    }

    public final Modal<T> setUseCloseHandler(boolean useCloseHandler) {
        this.useCloseHandler.setObject((Object)useCloseHandler);
        return this;
    }

    public Modal<T> show(boolean show) {
        this.show = show;
        return this;
    }

    public Modal<T> setCloseOnEscapeKey(boolean close) {
        this.closeOnEscapeKey = close;
        return this;
    }

    public Modal<T> setBackdrop(Backdrop backdrop) {
        this.backdrop = backdrop;
        return this;
    }

    public Modal<T> appendCloseDialogJavaScript(AjaxRequestTarget target) {
        target.prependJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "hide"));
        return this;
    }

    public Modal<T> close(AjaxRequestTarget target) {
        return this.appendCloseDialogJavaScript(target);
    }

    public Modal<T> appendShowDialogJavaScript(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "show"));
        this.appendDisableEnforceFocus(target);
        return this;
    }

    protected Modal<T> appendDisableEnforceFocus(AjaxRequestTarget target) {
        if (((Boolean)this.disableEnforceFocus.getObject()).booleanValue()) {
            target.appendJavaScript((CharSequence)"$.fn.modal.Constructor.prototype.enforceFocus = function () {};");
        }
        return this;
    }

    public Modal<T> show(AjaxRequestTarget target) {
        return this.appendShowDialogJavaScript(target);
    }

    protected String createActionScript(String markupId, String action) {
        return "$('#" + Strings2.escapeMarkupId((CharSequence)markupId) + "').modal('" + action + "');";
    }

    public Modal<T> addOpenerAttributesTo(Component component) {
        component.add(new Behavior[]{new AttributeModifier("data-toggle", (Serializable)((Object)"modal"))});
        component.add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)("#" + this.getMarkupId(true))))});
        return this;
    }

    public Modal<T> addCloseButton(IModel<String> label) {
        ModalCloseButton button = new ModalCloseButton(label);
        button.setAnchor(this);
        return this.addButton((Component)button);
    }

    public Modal<T> addCloseButton() {
        return this.addCloseButton((IModel<String>)Model.of((Serializable)((Object)"Close")));
    }

    public Modal<T> addButton(Component button) {
        if (!BUTTON_MARKUP_ID.equals(button.getId())) {
            throw new IllegalArgumentException(String.format("Invalid button markup id. Must be '%s'.", BUTTON_MARKUP_ID));
        }
        if (button instanceof ModalCloseButton) {
            // empty if block
        }
        this.buttons.add(button);
        return this;
    }

    protected void onInitialize() {
        super.onInitialize();
        if (((Boolean)this.useCloseHandler.getObject()).booleanValue()) {
            this.add(new Behavior[]{this.closeBehavior});
        }
    }

    private void handleCloseEvent(AjaxRequestTarget target) {
        if (this.isVisible()) {
            this.onClose(target);
            this.appendCloseDialogJavaScript(target);
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (Strings.isEmpty((CharSequence)this.headerLabel.getDefaultModelObjectAsString())) {
            this.headerLabel.setDefaultModelObject((Object)"&nbsp;");
            this.headerLabel.setEscapeModelStrings(false);
        }
        this.footer.setVisible(this.buttons.size() > 0);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(this.getMarkupId(true))));
    }

    private String createInitializerScript(String markupId) {
        return this.addCloseHandlerScript(markupId, this.createBasicInitializerScript(markupId));
    }

    protected String createBasicInitializerScript(String markupId) {
        return "$('#" + markupId + "').modal({keyboard:" + this.useKeyboard() + ", show:" + this.showImmediately() + "})";
    }

    private String addCloseHandlerScript(String markupId, String script) {
        if (((Boolean)this.useCloseHandler.getObject()).booleanValue()) {
            return script + ";$('#" + markupId + "').on('hidden', function () { " + "  Wicket.Ajax.ajax({'u':'" + this.closeBehavior.getCallbackUrl() + "','c':'" + markupId + "'});" + "})";
        }
        return script;
    }

    protected final boolean useFadein() {
        return this.fadein;
    }

    protected final boolean useKeyboard() {
        return this.keyboard;
    }

    protected final boolean showImmediately() {
        return this.show;
    }

    public final Modal<T> setFadeIn(boolean fadein) {
        this.fadein = fadein;
        return this;
    }

    public final Modal<T> setUseKeyboard(boolean keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    public final Modal<T> setDisableEnforceFocus(boolean disable) {
        this.disableEnforceFocus.setObject((Object)disable);
        return this;
    }

    public static enum Backdrop {
        TRUE,
        FALSE,
        STATIC;

    }

    public static enum Size implements ICssClassNameProvider
    {
        Default(""),
        Small("sm"),
        Medium("md"),
        Large("lg");

        private final String cssClassName;

        private Size(String cssClassName) {
            this.cssClassName = cssClassName;
        }

        @Override
        public String cssClassName() {
            return "modal-" + this.cssClassName;
        }
    }
}

