/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.list;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class ListBehavior
extends BootstrapBaseBehavior {
    private boolean unstyled = false;
    private boolean horizontal;
    private boolean inline;
    private final Type type;

    public static ListBehavior description() {
        return new ListBehavior(Type.DL);
    }

    public static ListBehavior unordered() {
        return new ListBehavior(Type.UL);
    }

    public static ListBehavior ordered() {
        return new ListBehavior(Type.OL);
    }

    public ListBehavior() {
        this(Type.DYNAMIC);
    }

    private ListBehavior(Type type) {
        this.type = type;
    }

    public ListBehavior horizontal() {
        this.horizontal = true;
        return this;
    }

    public ListBehavior inline() {
        this.inline = true;
        return this;
    }

    public ListBehavior unstyled() {
        this.unstyled = true;
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        if (!Type.DYNAMIC.equals((Object)this.type)) {
            tag.setName(this.type.name().toLowerCase());
        }
        Components.assertTag(component, tag, "ul", "ol", "dl");
        if (this.unstyled && Type.UL.equals((Object)this.type)) {
            Attributes.addClass(tag, "list-unstyled");
        }
        if (this.inline && Type.UL.equals((Object)this.type)) {
            Attributes.addClass(tag, "list-inline");
        }
        if (this.horizontal && Type.DL.equals((Object)this.type)) {
            Attributes.addClass(tag, "dl-horizontal");
        }
    }

    private static enum Type {
        DYNAMIC,
        OL,
        UL,
        DL;

    }
}

