/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.ProgressBar;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Duration;

public abstract class UpdatableProgressBar
extends ProgressBar {
    Duration updateInterval = Duration.seconds((int)5);
    private UpdateBehavior behavior;

    public UpdatableProgressBar(String id) {
        this(id, null);
    }

    public UpdatableProgressBar(String id, IModel<Integer> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.active(true);
        this.behavior = new UpdateBehavior(this.updateInterval){

            protected void onPostProcessTarget(AjaxRequestTarget target) {
                super.onPostProcessTarget(target);
                UpdatableProgressBar.this.onPostProcessTarget(target);
            }
        };
        this.add(new Behavior[]{this.behavior});
    }

    public Duration updateInterval() {
        return this.behavior.updateInterval();
    }

    public UpdatableProgressBar updateInterval(Duration updateInterval) {
        this.behavior.updateInterval(updateInterval);
        return this;
    }

    protected void onPostProcessTarget(AjaxRequestTarget target) {
        this.value(this.newValue());
        if (this.complete()) {
            this.behavior.stop(target);
            this.onComplete(target);
        }
    }

    protected void onComplete(AjaxRequestTarget target) {
        this.active(false);
        this.striped(false);
        target.add(new Component[]{this});
    }

    protected abstract IModel<Integer> newValue();

    private static abstract class UpdateBehavior
    extends AjaxSelfUpdatingTimerBehavior {
        private UpdateBehavior(Duration updateInterval) {
            super(updateInterval);
        }

        private void updateInterval(Duration duration) {
            this.setUpdateInterval(duration);
        }

        private Duration updateInterval() {
            return this.getUpdateInterval();
        }
    }
}

