/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.navbar;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.Invertible;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.INavbarComponent;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarText;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Behaviors;
import de.agilecoders.wicket.core.util.Models;
import de.agilecoders.wicket.jquery.util.Generics2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class Navbar
extends Panel
implements Invertible<Navbar> {
    private static final String COMPONENT_ID = "component";
    private static final NavbarComponentToComponentFunction NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION = new NavbarComponentToComponentFunction(Navbar.componentId());
    private static final PositionFilter POSITION_FILTER_LEFT = new PositionFilter(ComponentPosition.LEFT);
    private static final PositionFilter POSITION_FILTER_RIGHT = new PositionFilter(ComponentPosition.RIGHT);
    private IModel<String> invertModel;
    private CssClassNameAppender activeStateAppender;
    private final IModel<Position> position = Model.of((Serializable)((Object)Position.DEFAULT));
    private final IModel<Boolean> fluid = Model.of((Serializable)Boolean.valueOf(false));
    private final Component brandNameLink;
    private final List<INavbarComponent> components = new ArrayList<INavbarComponent>();
    private final RepeatingView extraItems;

    public static String componentId() {
        return COMPONENT_ID;
    }

    public Navbar(String componentId) {
        this(componentId, (IModel<?>)Model.of());
    }

    public Navbar(String componentId, IModel<?> model) {
        super(componentId, model);
        BootstrapResourcesBehavior.addTo((Component)this);
        TransparentWebMarkupContainer container = this.newContainer("container");
        TransparentWebMarkupContainer collapse = this.newCollapseContainer("collapse");
        TransparentWebMarkupContainer collapseButton = this.newCollapseButton("collapseButton", "#" + collapse.getMarkupId());
        this.brandNameLink = this.newBrandNameLink("brandName");
        Component leftAlignedComponentListView = this.newNavigation("navLeftList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_LEFT));
        Component rightAlignedComponentListView = this.newNavigation("navRightList", this.newPositionDependedComponentModel(this.components, POSITION_FILTER_RIGHT));
        this.extraItems = new RepeatingView("extraItems");
        collapse.add(new Component[]{this.extraItems});
        this.activeStateAppender = new CssClassNameAppender("active");
        this.invertModel = Model.of((Serializable)((Object)""));
        this.add(new Component[]{container, collapse, collapseButton, this.newToggleNavigationLabel("toggleNavigationLabel"), this.brandNameLink, leftAlignedComponentListView, rightAlignedComponentListView});
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass(tag, "navbar", "navbar-default", (String)this.invertModel.getObject(), ((Position)this.position.getObject()).cssClassName());
        Attributes.set(tag, "role", "navigation");
    }

    private IModel<List<Component>> newPositionDependedComponentModel(final List<INavbarComponent> components, final PositionFilter withPosition) {
        return new LoadableDetachableModel<List<Component>>(){

            public List<Component> load() {
                return Generics2.transform((List)Generics2.filter((Iterable)components, (Predicate)withPosition), (Function)NAVBAR_COMPONENT_TO_COMPONENT_FUNCTION);
            }
        };
    }

    protected Component newNavigation(String componentId, IModel<List<Component>> listModel) {
        return new ListView<Component>(componentId, listModel){

            protected void populateItem(ListItem<Component> components) {
                Activatable activatable;
                Component component = (Component)components.getModelObject();
                components.add(new Component[]{component});
                Behaviors.remove(components, (Behavior)Navbar.this.activeStateAppender);
                if (component instanceof Activatable && (activatable = (Activatable)component).isActive(component)) {
                    components.add(new Behavior[]{Navbar.this.activeStateAppender});
                }
                if (component instanceof Invertible) {
                    ((Invertible)component).setInverted(!Models.isNullOrEmpty((IModel<String>)Navbar.this.invertModel));
                }
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setVisibilityAllowed(this.getList().size() > 0);
            }
        };
    }

    protected Component newBrandNameLink(String componentId) {
        BookmarkablePageLink<Page> link = new BookmarkablePageLink<Page>(componentId, this.getHomePage()){

            protected void onConfigure() {
                super.onConfigure();
                Component brandLabel = this.get("brandLabel");
                brandLabel.configure();
                if (brandLabel.isVisible()) {
                    this.setVisible(true);
                } else {
                    Component brandImage = this.get("brandImage");
                    brandImage.configure();
                    this.setVisible(brandImage.isVisible());
                }
            }
        };
        link.setOutputMarkupPlaceholderTag(true);
        link.add(new Component[]{this.newBrandLabel("brandLabel")});
        link.add(new Component[]{this.newBrandImage("brandImage")});
        return link;
    }

    protected Label newBrandLabel(String markupId) {
        return new Label(markupId){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getDefaultModel() != null);
            }
        };
    }

    protected Image newBrandImage(String markupId) {
        return new Image(markupId, (IModel)Model.of((Serializable)((Object)""))){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(this.getImageResourceReference() != null || this.getImageResource() != null);
            }
        };
    }

    protected Class<? extends Page> getHomePage() {
        return this.getApplication().getHomePage();
    }

    public Position getPosition() {
        return (Position)this.position.getObject();
    }

    public boolean isFluid() {
        return (Boolean)this.fluid.getObject();
    }

    public final Navbar addComponents(INavbarComponent ... components) {
        return this.addComponents(Generics2.newArrayList((Object[])components));
    }

    public final Navbar addComponents(NavbarText component) {
        this.extraItems.add(new Component[]{component});
        return this;
    }

    public final String newExtraItemId() {
        return this.extraItems.newChildId();
    }

    public final Navbar addComponents(List<INavbarComponent> components) {
        this.components.addAll(components);
        return this;
    }

    protected Label newToggleNavigationLabel(String componentId) {
        return new Label(componentId, "Toggle Navigation");
    }

    protected TransparentWebMarkupContainer newContainer(String componentId) {
        return new TransparentWebMarkupContainer(componentId){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Attributes.removeClass(tag, "container", "container-fluid");
                if (Navbar.this.isFluid()) {
                    Attributes.addClass(tag, "container-fluid");
                } else {
                    Attributes.addClass(tag, "container");
                }
            }
        };
    }

    protected TransparentWebMarkupContainer newCollapseButton(String componentId, String selector) {
        TransparentWebMarkupContainer button = new TransparentWebMarkupContainer(componentId);
        Args.notNull((Object)selector, (String)"selector");
        button.add(new Behavior[]{new AttributeModifier("data-target", (Serializable)((Object)selector))});
        return button;
    }

    protected TransparentWebMarkupContainer newCollapseContainer(String componentId) {
        TransparentWebMarkupContainer collapse = new TransparentWebMarkupContainer(componentId);
        collapse.setOutputMarkupId(true);
        return collapse;
    }

    public Navbar setBrandName(IModel<String> brandName) {
        Component name = this.brandNameLink.get("brandLabel");
        name.setDefaultModel(brandName);
        return this;
    }

    public Navbar setBrandImage(ResourceReference imageResourceReference, IModel<String> imageAltAttrModel) {
        Image brandImage = (Image)this.brandNameLink.get("brandImage");
        brandImage.setImageResourceReference(imageResourceReference);
        if (!Models.isNullOrEmpty(imageAltAttrModel)) {
            brandImage.add(new Behavior[]{new AttributeModifier("alt", imageAltAttrModel)});
        }
        return this;
    }

    @Override
    public Navbar setInverted(boolean invert) {
        this.invertModel.setObject((Object)(invert ? "navbar-inverse" : ""));
        return this;
    }

    public Navbar fluid() {
        this.fluid.setObject((Object)true);
        return this;
    }

    public Navbar setPosition(Position position) {
        this.position.setObject((Object)position);
        return this;
    }

    private static final class NavbarComponentToComponentFunction
    implements Function<INavbarComponent, Component>,
    IClusterable {
        private final String markupId;

        private NavbarComponentToComponentFunction(String markupId) {
            Args.isFalse((boolean)Strings.isEmpty((CharSequence)markupId), (String)"markupId", (Object[])new Object[0]);
            this.markupId = markupId;
        }

        public Component apply(INavbarComponent navbarComponent) {
            return navbarComponent.create(this.markupId);
        }
    }

    private static final class PositionFilter
    implements Predicate<INavbarComponent>,
    IClusterable {
        private final ComponentPosition position;

        private PositionFilter(ComponentPosition position) {
            Args.notNull((Object)((Object)position), (String)"position");
            this.position = position;
        }

        public boolean apply(INavbarComponent navbarComponent) {
            return navbarComponent != null && this.position.equals((Object)navbarComponent.getPosition());
        }
    }

    public static enum ComponentPosition {
        LEFT,
        RIGHT;

    }

    public static enum Position implements ICssClassNameProvider
    {
        TOP("navbar-fixed-top"),
        STATIC_TOP("navbar-static-top"),
        BOTTOM("navbar-fixed-bottom"),
        DEFAULT("");

        private final String className;

        private Position(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

