/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.settings;

import de.agilecoders.wicket.core.settings.SessionThemeProvider;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.cookies.CookieUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class CookieThemeProvider
extends SessionThemeProvider {
    private static final String DEFAULT_COOKIE_NAME = "wb-theme";
    private final String cookieName;
    private final CookieDefaults cookieDefaults;

    public CookieThemeProvider() {
        this(DEFAULT_COOKIE_NAME, new CookieDefaults());
    }

    public CookieThemeProvider(String cookieName, CookieDefaults cookieDefaults) {
        this.cookieName = (String)Args.notEmpty((CharSequence)cookieName, (String)"cookieName");
        this.cookieDefaults = (CookieDefaults)Args.notNull((Object)cookieDefaults, (String)"cookieDefaults");
    }

    @Override
    protected String loadThemeName() {
        String themeName = super.loadThemeName();
        if (Strings.isEmpty((CharSequence)themeName)) {
            CookieUtils cookieUtils = new CookieUtils(this.cookieDefaults);
            themeName = cookieUtils.load(this.cookieName);
        }
        return themeName;
    }

    @Override
    protected void storeThemeName(String themeName) {
        super.storeThemeName(themeName);
        CookieUtils cookieUtils = new CookieUtils(this.cookieDefaults);
        cookieUtils.save(this.cookieName, new String[]{themeName});
    }
}

