/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class ModalCloseButton
extends AjaxLink<String> {
    private final ButtonBehavior buttonBehavior;
    private Modal<?> anchor;

    public ModalCloseButton() {
        this((IModel<String>)Model.of((Serializable)((Object)"Close")));
    }

    public ModalCloseButton(IModel<String> label) {
        this("button", label);
    }

    public ModalCloseButton(String id, IModel<String> label) {
        super(id, label);
        this.setBody(this.getDefaultModel());
        this.buttonBehavior = new ButtonBehavior(Buttons.Type.Default);
        this.add(new Behavior[]{new AttributeModifier("data-dismiss", (Serializable)((Object)"modal"))});
        this.add(new Behavior[]{this.buttonBehavior});
    }

    public ModalCloseButton type(Buttons.Type type) {
        this.buttonBehavior.setType(type);
        return this;
    }

    public ModalCloseButton size(Buttons.Size size) {
        this.buttonBehavior.setSize(size);
        return this;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        String anchorMarkupId;
        super.updateAjaxAttributes(attributes);
        Component _anchor = this.anchor;
        if (_anchor == null) {
            _anchor = (Component)this.findParent(Modal.class);
        }
        if (_anchor != null && !Strings.isEmpty((CharSequence)(anchorMarkupId = _anchor.getMarkupId()))) {
            AjaxCallListener listener = new AjaxCallListener();
            listener.onBeforeSend((CharSequence)String.format("document.location.hash='%s';", anchorMarkupId));
            listener.onBeforeSend((CharSequence)String.format("$('#%s').modal('hide');", anchorMarkupId));
            attributes.getAjaxCallListeners().add(listener);
        }
    }

    public void onClick(AjaxRequestTarget target) {
    }

    public ModalCloseButton setAnchor(Modal<?> anchor) {
        this.anchor = anchor;
        return this;
    }
}

