/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.tabs;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ClientSideBootstrapTabbedPanel<T extends ITab>
extends GenericPanel<Integer> {
    public ClientSideBootstrapTabbedPanel(String id, List<T> tabs) {
        this(id, tabs, null);
    }

    public ClientSideBootstrapTabbedPanel(String id, List<T> tabs, IModel<Integer> activeTabIndexModel) {
        super(id, activeTabIndexModel);
        Args.notEmpty(tabs, (String)"tabs");
        WebMarkupContainer panelsContainer = this.newTabsContentsContainer("panelsContainer");
        this.add(new Component[]{panelsContainer});
        RepeatingView panels = new RepeatingView("panels");
        panelsContainer.add(new Component[]{panels});
        WebMarkupContainer tabsContainer = this.newTabsContainer("tabsContainer");
        this.add(new Component[]{tabsContainer});
        RepeatingView tabsView = new RepeatingView("tabs");
        tabsContainer.add(new Component[]{tabsView});
        int tabIndex = 0;
        for (ITab tab : tabs) {
            if (!tab.isVisible()) continue;
            WebMarkupContainer panel = this.createContentPanel(panels.newChildId(), tab, tabIndex, activeTabIndexModel);
            panels.add(new Component[]{panel});
            WebMarkupContainer tabPanel = this.createTabPanel(panels.newChildId(), tab, tabIndex, activeTabIndexModel, panel.getMarkupId());
            tabsView.add(new Component[]{tabPanel});
            ++tabIndex;
        }
    }

    private WebMarkupContainer createTabPanel(String id, T tab, int tabIndex, IModel<Integer> activeTabIndexModel, String tabPanelId) {
        WebMarkupContainer tabPanel = new WebMarkupContainer(id);
        tabPanel.add(new Behavior[]{new AttributeModifier("class", (IModel & Serializable)() -> {
            int activeTab = activeTabIndexModel != null ? (Integer)activeTabIndexModel.getObject() : 0;
            boolean isActive = tabIndex == activeTab;
            return "tab" + tabIndex + (isActive ? " active" : "");
        })});
        WebMarkupContainer link = this.newTabLink("link", tabPanelId, tabIndex);
        tabPanel.add(new Component[]{link});
        link.add(new Component[]{this.newTabTitleLabel("title", (IModel<String>)this.wrap(tab.getTitle()), tabIndex)});
        return tabPanel;
    }

    private WebMarkupContainer createContentPanel(String id, T tab, int tabIndex, IModel<Integer> activeTabIndexModel) {
        WebMarkupContainer panel = tab.getPanel(id);
        panel.setRenderBodyOnly(false);
        panel.add(new Behavior[]{new AttributeModifier("class", (IModel & Serializable)() -> {
            int activeTab = activeTabIndexModel != null ? (Integer)activeTabIndexModel.getObject() : 0;
            boolean isActive = tabIndex == activeTab;
            return "tab" + tabIndex + (isActive ? " tab-pane fade in active" : " tab-pane fade");
        })});
        panel.setOutputMarkupId(true);
        return panel;
    }

    protected Component newTabTitleLabel(String id, IModel<String> title, int tabIndex) {
        return new Label(id, title);
    }

    protected WebMarkupContainer newTabLink(String id, final String href, int tabIndex) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("data-toggle", (CharSequence)"tab");
                tag.put("href", (CharSequence)("#" + href));
            }
        };
    }

    protected WebMarkupContainer newTabsContentsContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", ClientSideBootstrapTabbedPanel.this.getPanelsContainerCssClass());
            }
        };
    }

    protected CharSequence getPanelsContainerCssClass() {
        return "tab-content";
    }

    protected WebMarkupContainer newTabsContainer(String id) {
        return new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", ClientSideBootstrapTabbedPanel.this.getTabContainerCssClass());
            }
        };
    }

    protected CharSequence getTabContainerCssClass() {
        return "nav nav-tabs";
    }
}

