/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class DropDownVariationBehavior
extends BootstrapBaseBehavior {
    private final IModel<Variation> alignment;

    public DropDownVariationBehavior(IModel<Variation> alignment) {
        this.alignment = (IModel)Args.notNull(alignment, (String)"alignment");
    }

    public DropDownVariationBehavior(Variation alignment) {
        this((IModel<Variation>)Model.of((Serializable)((Object)((Variation)Args.notNull((Object)alignment, (String)"alignment")))));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.removeClass(tag, Variation.DROPLEFT.cssClassName(), Variation.DROPRIGHT.cssClassName(), Variation.DROPUP.cssClassName());
        Variation value = (Variation)this.alignment.getObject();
        switch (value) {
            case DROPLEFT: 
            case DROPRIGHT: 
            case DROPUP: {
                Attributes.addClass(tag, value.cssClassName());
            }
        }
    }

    public static enum Variation implements ICssClassNameProvider
    {
        DROPRIGHT("dropright"),
        DROPLEFT("dropleft"),
        DROPUP("dropup"),
        DROPDOWN("");

        private String className;

        private Variation(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

