/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.ButtonList;
import de.agilecoders.wicket.core.util.Attributes;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Panel;

public abstract class Pagination
extends Panel {
    private final WebMarkupContainer paginationUl;

    public Pagination(String markupId) {
        this(markupId, Alignment.Left, Size.Default);
    }

    public Pagination(String markupId, Alignment alignment) {
        this(markupId, alignment, Size.Default);
    }

    public Pagination(String markupId, Size size) {
        this(markupId, Alignment.Left, size);
    }

    public Pagination(String markupId, Alignment ignored, final Size size) {
        super(markupId);
        this.paginationUl = new WebMarkupContainer("paginationUl"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Attributes.addClass(tag, "pagination", size.cssClassName());
            }
        };
        this.add(new Component[]{this.paginationUl});
        this.paginationUl.add(new Component[]{this.newButtonList("buttons")});
        BootstrapBaseBehavior.addTo((Component)this);
    }

    protected ButtonList newButtonList(String markupId) {
        return new ButtonList(markupId, this.newPaginationButtons(ButtonList.getButtonMarkupId()));
    }

    protected abstract List<AbstractLink> newPaginationButtons(String var1);

    @Deprecated
    public static enum Alignment implements ICssClassNameProvider
    {
        Centered,
        Right,
        Left;


        @Override
        public String cssClassName() {
            return this.equals(Left) ? "" : "pagination-" + this.name().toLowerCase();
        }
    }

    public static enum Size implements ICssClassNameProvider
    {
        Large("lg"),
        Small("sm"),
        Default("");

        private final String size;

        private Size(String size) {
            this.size = size;
        }

        @Override
        public String cssClassName() {
            return this.equals(Default) ? "" : "pagination-" + this.size;
        }
    }
}

