/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;

public class BorderBehavior
extends BootstrapBaseBehavior {
    private Color color = Color.Secondary;
    private Radius radius = Radius.None;
    private Type type = Type.None;

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, this.type.cssClassName(), this.color.cssClassName(), this.radius.cssClassName());
    }

    public BorderBehavior color(Color color) {
        this.color = color;
        return this;
    }

    public BorderBehavior radius(Radius radius) {
        this.radius = radius;
        return this;
    }

    public BorderBehavior type(Type type) {
        this.type = type;
        return this;
    }

    public static enum Color {
        Primary("primary"),
        Secondary("secondary"),
        Success("success"),
        Danger("danger"),
        Warning("warning"),
        Info("info"),
        Light("light"),
        Dark("dark"),
        White("white");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return String.format("border-%s", this.value);
        }
    }

    public static enum Radius {
        All("rounded"),
        Top("rounded-top"),
        Right("rounded-right"),
        Bottom("rounded-bottom"),
        Left("rounded-left"),
        Circle("rounded-circle"),
        None("rounded-0");

        private final String value;

        private Radius(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return this.value;
        }
    }

    public static enum Type {
        All("border"),
        Top("border-top"),
        Right("border-right"),
        Bottom("border-bottom"),
        Left("border-left"),
        ExceptTop("border-top-0"),
        ExceptRight("border-right-0"),
        ExceptBottom("border-bottom-0"),
        ExceptLeft("border-left-0"),
        None("border-0");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String cssClassName() {
            return this.value;
        }
    }
}

