/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Activatable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ButtonList
extends ListView<AbstractLink> {
    public static String getButtonMarkupId() {
        return "button";
    }

    public ButtonList(String markupId, List<AbstractLink> list) {
        super(markupId, list);
        this.setOutputMarkupId(true);
    }

    public ButtonList(String id, IModel<List<AbstractLink>> model) {
        super(id, model);
        this.setOutputMarkupId(true);
    }

    public final boolean hasActiveButton(Component activeButton) {
        Class pageClass = activeButton.getPage().getPageClass();
        for (AbstractLink link : this.getList()) {
            if (!(link instanceof Activatable ? ((Activatable)link).isActive(activeButton) : link instanceof BookmarkablePageLink && ((BookmarkablePageLink)link).getPageClass().equals(pageClass))) continue;
            return true;
        }
        return false;
    }

    protected void populateItem(ListItem<AbstractLink> item) {
        AbstractLink link = (AbstractLink)item.getModelObject();
        Args.isTrue((boolean)ButtonList.getButtonMarkupId().equals(link.getId()), (String)"component id is invalid, please use ButtonList.getButtonMarkupId()", (Object[])new Object[0]);
        item.add(new Component[]{link});
        this.configureLink(link);
    }

    protected void configureLink(AbstractLink link) {
        link.configure();
        if (!link.isEnabled()) {
            link.add(new Behavior[]{new CssClassNameAppender("disabled")});
        }
    }
}

