/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.common;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.INotificationMessage;
import java.io.Serializable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;

public class NotificationMessage
implements INotificationMessage {
    private final IModel<String> message;
    private final IModel<String> header;
    private boolean inlineHeader;
    private boolean escapeModelStrings = true;
    private Duration duration;

    public NotificationMessage(IModel<String> message) {
        this(message, (IModel<String>)Model.of((Serializable)((Object)"")), true);
    }

    public NotificationMessage(IModel<String> message, IModel<String> header) {
        this(message, header, true);
    }

    public NotificationMessage(IModel<String> message, IModel<String> header, boolean inlineHeader) {
        this.message = message;
        this.header = header;
        this.inlineHeader = inlineHeader;
    }

    public NotificationMessage escapeModelStrings(boolean escapeModelStrings) {
        this.escapeModelStrings = escapeModelStrings;
        return this;
    }

    public NotificationMessage hideAfter(Duration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public Duration hideAfter() {
        return this.duration;
    }

    @Override
    public IModel<String> message() {
        return this.message;
    }

    @Override
    public IModel<String> header() {
        return this.header;
    }

    @Override
    public boolean inlineHeader() {
        return this.inlineHeader;
    }

    @Override
    public boolean escapeModelStrings() {
        return this.escapeModelStrings;
    }

    public String toString() {
        return Strings.isEmpty((CharSequence)((CharSequence)this.header.getObject())) ? (String)this.message.getObject() : (String)this.header.getObject() + " " + (String)this.message.getObject();
    }
}

