/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components;

import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import org.apache.wicket.util.time.Duration;

public class TooltipConfig
extends AbstractConfig {
    private static final IKey<Boolean> Animation = TooltipConfig.newKey((String)"animation", (Object)true);
    private static final IKey<String> TooltipPlacement = TooltipConfig.newKey((String)"placement", (Object)"top");
    private static final IKey<String> Selector = TooltipConfig.newKey((String)"selector", (Object)"false");
    private static final IKey<String> Content = TooltipConfig.newKey((String)"content", (Object)"");
    private static final IKey<String> Title = TooltipConfig.newKey((String)"title", (Object)"");
    private static final IKey<String> Trigger = TooltipConfig.newKey((String)"trigger", (Object)"hover");
    private static final IKey<Long> Delay = TooltipConfig.newKey((String)"delay", (Object)0L);
    private static final IKey<Boolean> Html = TooltipConfig.newKey((String)"html", (Object)false);
    private static final IKey<Boolean> Sanitize = TooltipConfig.newKey((String)"sanitize", (Object)true);

    public TooltipConfig withAnimation(boolean value) {
        this.put(Animation, value);
        return this;
    }

    public TooltipConfig withPlacement(IPlacement value) {
        this.put(TooltipPlacement, value.value());
        return this;
    }

    public TooltipConfig withSelector(String value) {
        this.put(Selector, value);
        return this;
    }

    public TooltipConfig withTitle(String value) {
        this.put(Title, value);
        return this;
    }

    public TooltipConfig withContent(String value) {
        this.put(Content, value);
        return this;
    }

    public TooltipConfig withTrigger(OpenTrigger value) {
        this.put(Trigger, value.name());
        return this;
    }

    public TooltipConfig withDelay(Duration value) {
        this.put(Delay, value.getMilliseconds());
        return this;
    }

    public TooltipConfig withHtml(boolean value) {
        this.put(Html, value);
        return this;
    }

    public TooltipConfig withSanitizer(boolean value) {
        this.put(Sanitize, value);
        return this;
    }

    public static enum OpenTrigger {
        click,
        hover,
        focus,
        manual;

    }

    public static interface IPlacement {
        public String value();
    }

    public static enum Placement implements IPlacement
    {
        top,
        bottom,
        right,
        left;


        @Override
        public String value() {
            return this.name();
        }
    }
}

