/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.block;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.block.prettyprint.PrettifyCssResourceReference;
import de.agilecoders.wicket.core.markup.html.bootstrap.block.prettyprint.PrettifyJavaScriptReference;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.core.util.CssClassNames;
import de.agilecoders.wicket.core.util.References;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;

public class CodeBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final IModel<Boolean> lineNumbers = Model.of((Serializable)Boolean.valueOf(false));
    private final IModel<String> cssClassNameModel = Model.of((Serializable)((Object)""));
    private final IModel<Language> language = Model.of((Serializable)((Object)Language.DYNAMIC));
    private final IModel<Integer> from = Model.of((Serializable)Integer.valueOf(0));
    private final CssClassNameAppender cssClassNameAppender = new CssClassNameAppender(this.cssClassNameModel);

    public void detach(Component component) {
        super.detach(component);
        this.lineNumbers.detach();
        this.cssClassNameModel.detach();
        this.language.detach();
        this.from.detach();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)PrettifyCssResourceReference.INSTANCE));
        References.renderWithFilter(Bootstrap.getSettings(), response, JavaScriptHeaderItem.forReference((ResourceReference)PrettifyJavaScriptReference.INSTANCE));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createInitializerScript(Strings2.getMarkupId((Component)component))));
    }

    private CharSequence createInitializerScript(CharSequence markupId) {
        return "$('#" + markupId + "').html(PR.prettyPrintOne($('#" + markupId + "').html().replace(/\\r\\n|\\r|\\n/g,'<br>'), '', $('#" + markupId + "').attr('class')));";
    }

    public void bind(Component component) {
        super.bind(component);
        BootstrapBaseBehavior.addTo(component);
        component.add(new Behavior[]{this.cssClassNameAppender});
    }

    public void unbind(Component component) {
        super.unbind(component);
        BootstrapBaseBehavior.removeFrom(component);
        component.remove(new Behavior[]{this.cssClassNameAppender});
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.cssClassNameModel.setObject((Object)this.createCssClassNames());
    }

    private String createCssClassNames() {
        return CssClassNames.parse("prettyprint").add(this.createLineNumbersCssClass(), ((Language)this.language.getObject()).cssClassName()).asString();
    }

    private String createLineNumbersCssClass() {
        if (this.hasLineNumbers()) {
            return "linenums" + (String)((Integer)this.from.getObject() > 0 ? ":" + this.from.getObject() : "");
        }
        return "";
    }

    public final boolean hasLineNumbers() {
        return (Boolean)this.lineNumbers.getObject();
    }

    public final CodeBehavior setShowLineNumbers(boolean showLineNumbers) {
        this.lineNumbers.setObject((Object)showLineNumbers);
        return this;
    }

    public final CodeBehavior setStartFromLine(int from) {
        this.setShowLineNumbers(true);
        this.from.setObject((Object)from);
        return this;
    }

    public final CodeBehavior setLanguage(Language language) {
        this.language.setObject((Object)language);
        return this;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Components.assertTag(component, tag, "code", "pre", "xmp");
    }

    public static enum Language implements ICssClassNameProvider
    {
        DYNAMIC,
        BSH,
        C,
        CC,
        CPP,
        CS,
        CSH,
        CYC,
        CV,
        HTM,
        HTML,
        JAVA,
        JS,
        M,
        MXML,
        PERL,
        PL,
        PM,
        PY,
        RB,
        SH,
        XHTML,
        XML,
        XSL,
        APOLLO,
        BASIC,
        CLJ,
        CSS,
        DART,
        ERLANG,
        GO,
        HS,
        LISP,
        LLVM,
        LUA,
        MATLAB,
        ML,
        MUMPS,
        N,
        PASCAL,
        PROTO,
        R,
        RD,
        SCALA,
        SQL,
        TCL,
        TEX,
        VB,
        VHDL,
        WIKI,
        XQ,
        YAML;


        @Override
        public String cssClassName() {
            if (!DYNAMIC.equals(this)) {
                return "lang-" + this.name().toLowerCase();
            }
            return "";
        }
    }
}

