/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.enums.PKBarcodeFormat;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@JsonPOJOBuilder(withPrefix="")
public class PKBarcodeBuilder
implements IPKValidateable,
IPKBuilder<PKBarcode> {
    private PKBarcode barcode = new PKBarcode();

    protected PKBarcodeBuilder() {
    }

    public PKBarcodeBuilder of(PKBarcode source) {
        if (source != null) {
            this.barcode = source.clone();
        }
        return this;
    }

    public PKBarcodeBuilder message(String message) {
        this.barcode.message = message;
        return this;
    }

    public PKBarcodeBuilder format(PKBarcodeFormat format) {
        this.barcode.format = format;
        return this;
    }

    public PKBarcodeBuilder messageEncoding(String messageEncoding) {
        this.barcode.messageEncoding = messageEncoding;
        return this;
    }

    public PKBarcodeBuilder messageEncoding(Charset messageEncoding) {
        return this.messageEncoding(messageEncoding == null ? null : messageEncoding.name());
    }

    public PKBarcodeBuilder altText(String altText) {
        this.barcode.altText = altText;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        if (this.barcode.format == null || StringUtils.isEmpty((CharSequence)this.barcode.message) || StringUtils.isEmpty((CharSequence)this.barcode.messageEncoding)) {
            return Collections.singletonList("Not all required Fields are set. Format: " + (Object)((Object)this.barcode.format) + " Message: " + this.barcode.message + " MessageEncoding: " + this.barcode.messageEncoding);
        }
        return Collections.emptyList();
    }

    @Override
    public PKBarcode build() {
        return this.barcode;
    }
}

