/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.config.AdminClientProperties;
import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.ApplicationFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultApplicationFactory
implements ApplicationFactory {
    private AdminClientProperties client;
    private ServerProperties server;
    private ManagementServerProperties management;
    private Integer localServerPort;
    private Integer localManagementPort;
    private final ServletContext servletContext;
    private String healthEndpointPath;

    public DefaultApplicationFactory(AdminClientProperties client, ManagementServerProperties management, ServerProperties server, ServletContext servletContext, String healthEndpointPath) {
        this.client = client;
        this.management = management;
        this.server = server;
        this.servletContext = servletContext;
        this.healthEndpointPath = healthEndpointPath;
    }

    @Override
    public Application createApplication() {
        return Application.create(this.getName()).withHealthUrl(this.getHealthUrl()).withManagementUrl(this.getManagementUrl()).withServiceUrl(this.getServiceUrl()).withMetadata(this.getMetadata()).build();
    }

    protected String getName() {
        return this.client.getName();
    }

    protected String getServiceUrl() {
        if (this.client.getServiceUrl() != null) {
            return UriComponentsBuilder.fromUriString((String)this.client.getServiceUrl()).toUriString();
        }
        String baseUrl = this.client.getServiceBaseUrl();
        if (this.getLocalServerPort() == null && StringUtils.isEmpty((Object)baseUrl)) {
            throw new IllegalStateException("service-base-url must be set when deployed to servlet-container");
        }
        UriComponentsBuilder builder = !StringUtils.isEmpty((Object)baseUrl) ? UriComponentsBuilder.fromUriString((String)baseUrl) : UriComponentsBuilder.newInstance().scheme(this.getScheme(this.server.getSsl())).host(this.getServiceHost()).port(this.getLocalServerPort().intValue());
        return builder.path("/").path(this.servletContext.getContextPath()).path("/").toUriString();
    }

    protected String getManagementUrl() {
        UriComponentsBuilder builder;
        if (this.client.getManagementUrl() != null) {
            return this.client.getManagementUrl();
        }
        String baseUrl = this.client.getManagementBaseUrl();
        if (!StringUtils.isEmpty((Object)baseUrl)) {
            builder = UriComponentsBuilder.fromUriString((String)baseUrl);
        } else if (this.isManagementPortEqual()) {
            builder = UriComponentsBuilder.fromHttpUrl((String)this.getServiceUrl()).path("/").path(this.server.getServletPrefix());
        } else {
            Ssl ssl = this.management.getSsl() != null ? this.management.getSsl() : this.server.getSsl();
            builder = UriComponentsBuilder.newInstance().scheme(this.getScheme(ssl)).host(this.getManagementHost()).port(this.getLocalManagementPort().intValue());
        }
        return builder.path("/").path(this.management.getContextPath()).path("/").toUriString();
    }

    protected boolean isManagementPortEqual() {
        return this.getLocalManagementPort() == null || this.getLocalManagementPort().equals(this.getLocalServerPort());
    }

    protected String getHealthUrl() {
        if (this.client.getHealthUrl() != null) {
            return this.client.getHealthUrl();
        }
        return UriComponentsBuilder.fromHttpUrl((String)this.getManagementUrl()).path("/").path(this.getHealthEndpointPath()).path("/").toUriString();
    }

    protected Map<String, String> getMetadata() {
        return this.client.getMetadata();
    }

    protected String getServiceHost() {
        InetAddress address = this.server.getAddress();
        if (address == null) {
            address = this.getLocalHost();
        }
        return this.getHost(address);
    }

    protected String getManagementHost() {
        InetAddress address = this.management.getAddress();
        if (address != null) {
            return this.getHost(address);
        }
        return this.getServiceHost();
    }

    protected InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    protected Integer getLocalServerPort() {
        return this.localServerPort;
    }

    protected Integer getLocalManagementPort() {
        return this.localManagementPort;
    }

    protected String getHealthEndpointPath() {
        return this.healthEndpointPath;
    }

    protected String getScheme(Ssl ssl) {
        return ssl != null && ssl.isEnabled() ? "https" : "http";
    }

    protected String getHost(InetAddress address) {
        return this.client.isPreferIp() ? address.getHostAddress() : address.getCanonicalHostName();
    }

    @EventListener
    public void onApplicationReady(ApplicationReadyEvent event) {
        if (event.getApplicationContext() instanceof WebApplicationContext) {
            this.localServerPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.server.port", Integer.class);
            this.localManagementPort = (Integer)event.getApplicationContext().getEnvironment().getProperty("local.management.port", Integer.class, (Object)this.localServerPort);
        }
    }
}

