/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.jackson.ApplicationBeanSerializerModifier;
import de.codecentric.boot.admin.jackson.ApplicationDeserializer;
import de.codecentric.boot.admin.jackson.SanitizingMapSerializer;
import de.codecentric.boot.admin.journal.ApplicationEventJournal;
import de.codecentric.boot.admin.journal.web.JournalController;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.web.RegistryController;
import de.codecentric.boot.admin.web.AdminController;
import de.codecentric.boot.admin.web.PrefixHandlerMapping;
import de.codecentric.boot.admin.web.servlet.resource.ConcatenatingResourceResolver;
import de.codecentric.boot.admin.web.servlet.resource.PreferMinifiedFilteringResourceResolver;
import de.codecentric.boot.admin.web.servlet.resource.ResourcePatternResolvingResourceResolver;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.ResourceResolver;

@Configuration
public class AdminServerWebConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private final ApplicationEventPublisher publisher;
    private final ServerProperties server;
    private final ResourcePatternResolver resourcePatternResolver;
    private final AdminServerProperties adminServerProperties;
    private ApplicationContext applicationContext;

    public AdminServerWebConfiguration(ApplicationEventPublisher publisher, ServerProperties server, ResourcePatternResolver resourcePatternResolver, AdminServerProperties adminServerProperties) {
        this.publisher = publisher;
        this.server = server;
        this.resourcePatternResolver = resourcePatternResolver;
        this.adminServerProperties = adminServerProperties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        if (!this.hasConverter(converters, MappingJackson2HttpMessageConverter.class)) {
            ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().applicationContext(this.applicationContext).build();
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(objectMapper));
        }
    }

    private boolean hasConverter(List<HttpMessageConverter<?>> converters, Class<? extends HttpMessageConverter<?>> clazz) {
        for (HttpMessageConverter<?> converter : converters) {
            if (!clazz.isInstance(converter)) continue;
            return true;
        }
        return false;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.adminServerProperties.getContextPath() + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/"}).resourceChain(true).addResolver((ResourceResolver)new PreferMinifiedFilteringResourceResolver(".min"));
        registry.addResourceHandler(new String[]{this.adminServerProperties.getContextPath() + "/all-modules.css"}).resourceChain(true).addResolver((ResourceResolver)new ResourcePatternResolvingResourceResolver(this.resourcePatternResolver, "classpath*:/META-INF/spring-boot-admin-server-ui/*/module.css")).addResolver((ResourceResolver)new ConcatenatingResourceResolver("\n".getBytes()));
        registry.addResourceHandler(new String[]{this.adminServerProperties.getContextPath() + "/all-modules.js"}).resourceChain(true).addResolver((ResourceResolver)new ResourcePatternResolvingResourceResolver(this.resourcePatternResolver, "classpath*:/META-INF/spring-boot-admin-server-ui/*/module.js")).addResolver((ResourceResolver)new PreferMinifiedFilteringResourceResolver(".min")).addResolver((ResourceResolver)new ConcatenatingResourceResolver(";\n".getBytes()));
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        String contextPath = this.adminServerProperties.getContextPath();
        if (StringUtils.hasText((String)contextPath)) {
            registry.addRedirectViewController(contextPath, this.server.getPath(contextPath) + "/");
        }
        registry.addViewController(contextPath + "/").setViewName("forward:index.html");
    }

    @Bean
    public SimpleModule adminJacksonModule() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Application.class, (JsonDeserializer)new ApplicationDeserializer());
        module.setSerializerModifier((BeanSerializerModifier)new ApplicationBeanSerializerModifier(new SanitizingMapSerializer(this.adminServerProperties.getMetadataKeysToSanitize())));
        return module;
    }

    @Bean
    public PrefixHandlerMapping prefixHandlerMapping() {
        Map beans = this.applicationContext.getBeansWithAnnotation(AdminController.class);
        PrefixHandlerMapping prefixHandlerMapping = new PrefixHandlerMapping(beans.values().toArray(new Object[beans.size()]));
        prefixHandlerMapping.setPrefix(this.adminServerProperties.getContextPath());
        return prefixHandlerMapping;
    }

    @Bean
    @ConditionalOnMissingBean
    public RegistryController registryController(ApplicationRegistry applicationRegistry) {
        return new RegistryController(applicationRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    public JournalController journalController(ApplicationEventJournal applicationEventJournal) {
        return new JournalController(applicationEventJournal);
    }

    @EventListener
    public void onClientApplicationRegistered(ClientApplicationRegisteredEvent event) {
        this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
    }

    @EventListener
    public void onClientApplicationDeregistered(ClientApplicationDeregisteredEvent event) {
        this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
    }
}

