/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os;

import de.flapdoodle.os.Architecture;
import de.flapdoodle.os.BitSize;
import de.flapdoodle.os.CPUType;
import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.matcher.Matchers;
import java.util.List;

public enum CommonArchitecture implements Architecture
{
    X86_64(CPUType.X86, BitSize.B64, CommonArchitecture.osArchMatches("^(x8664|amd64|ia32e|em64t|x64|x86_64)$")),
    X86_32(CPUType.X86, BitSize.B32, CommonArchitecture.osArchMatches("^(x8632|x86|i[3-6]86|ia32|x32)$")),
    ARM_64(CPUType.ARM, BitSize.B64, CommonArchitecture.osArchMatches("^aarch64$")),
    ARM_32(CPUType.ARM, BitSize.B32, CommonArchitecture.osArchMatches("^(arm|arm32)$"));

    private final CPUType cpuType;
    private final BitSize bitSize;
    private final List<Peculiarity> peculiarities;

    private CommonArchitecture(CPUType cpuType, BitSize bitSize, DistinctPeculiarity<?> ... peculiarities) {
        this.cpuType = cpuType;
        this.bitSize = bitSize;
        this.peculiarities = HasPecularities.asList(peculiarities);
    }

    @Override
    public CPUType cpuType() {
        return this.cpuType;
    }

    @Override
    public BitSize bitSize() {
        return this.bitSize;
    }

    @Override
    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    private static DistinctPeculiarity<String> osArchMatches(String name) {
        return DistinctPeculiarity.of(CommonArchitecture.osArchProperty(), Matchers.matchPattern(name));
    }

    static Attribute<String> osArchProperty() {
        return Attributes.systemProperty("os.arch");
    }
}

