/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Distribution;
import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.Attributes;
import de.flapdoodle.os.common.collections.Immutables;
import de.flapdoodle.os.common.matcher.Matchers;
import de.flapdoodle.os.common.types.OsReleaseFile;
import de.flapdoodle.os.common.types.OsReleaseFileConverter;
import de.flapdoodle.os.linux.CentosVersion;
import de.flapdoodle.os.linux.UbuntuVersion;
import java.util.List;

public enum LinuxDistribution implements Distribution
{
    Ubuntu(UbuntuVersion.class, LinuxDistribution.osReleaseFileNameMatches("Ubuntu")),
    CentOS(CentosVersion.class, LinuxDistribution.osReleaseFileNameMatches("Centos"));

    private final List<Peculiarity<?>> peculiarities;
    private final List<Version> versions;

    private <T extends Enum<T>> LinuxDistribution(Class<T> versionClazz, Peculiarity<?> ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
        this.versions = Immutables.asList(versionClazz.getEnumConstants());
    }

    @Override
    public List<Peculiarity<?>> pecularities() {
        return this.peculiarities;
    }

    @Override
    public List<Version> versions() {
        return this.versions;
    }

    private static Peculiarity<OsReleaseFile> osReleaseFileNameMatches(String name) {
        return Peculiarity.of(LinuxDistribution.osReleaseFile(), Matchers.osReleaseFileEntry("NAME", ".*" + name + ".*"));
    }

    static Attribute<OsReleaseFile> osReleaseFile() {
        return Attributes.mappedTextFile("/etc/os-release", OsReleaseFileConverter::convert);
    }
}

