/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.common;

import de.flapdoodle.os.common.DistinctPeculiarity;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.OneOf;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.attributes.AttributeExtractor;
import de.flapdoodle.os.common.attributes.AttributeExtractorLookup;
import de.flapdoodle.os.common.matcher.Match;
import de.flapdoodle.os.common.matcher.Matcher;
import de.flapdoodle.os.common.matcher.MatcherLookup;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeculiarityInspector {
    private static Logger logger = LoggerFactory.getLogger(PeculiarityInspector.class);

    public static <T extends HasPecularities> T match(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, T ... items) {
        return PeculiarityInspector.match(attributeExtractorLookup, matcherLookup, Arrays.asList(items));
    }

    public static <T extends HasPecularities> T match(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Iterable<T> items) {
        List<T> matching = PeculiarityInspector.matching(attributeExtractorLookup, matcherLookup, items);
        if (matching.isEmpty()) {
            throw new IllegalArgumentException("no match out of " + items);
        }
        if (matching.size() > 1) {
            throw new IllegalArgumentException("more than one match: " + matching);
        }
        return (T)((HasPecularities)matching.get(0));
    }

    public static <T extends HasPecularities> Optional<T> find(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Iterable<? extends T> items) {
        List<T> matching = PeculiarityInspector.matching(attributeExtractorLookup, matcherLookup, items);
        if (matching.size() > 1) {
            logger.warn("more than one match: " + matching);
        }
        return matching.size() == 1 ? Optional.of(matching.get(0)) : Optional.empty();
    }

    public static <T extends HasPecularities> List<T> matching(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, T ... items) {
        return PeculiarityInspector.matching(attributeExtractorLookup, matcherLookup, Arrays.asList(items));
    }

    public static <T extends HasPecularities> List<T> matching(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Iterable<? extends T> items) {
        return StreamSupport.stream(items.spliterator(), false).filter(it -> PeculiarityInspector.matches(attributeExtractorLookup, matcherLookup, it.pecularities())).collect(Collectors.toList());
    }

    public static boolean matches(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, Iterable<? extends Peculiarity> peculiarities) {
        Iterator<? extends Peculiarity> iterator = peculiarities.iterator();
        if (iterator.hasNext()) {
            Peculiarity it = iterator.next();
            if (it instanceof DistinctPeculiarity) {
                return PeculiarityInspector.matches(attributeExtractorLookup, matcherLookup, (DistinctPeculiarity)it);
            }
            if (it instanceof OneOf) {
                return PeculiarityInspector.matches(attributeExtractorLookup, matcherLookup, (OneOf)it);
            }
            throw new IllegalArgumentException("unknown peculiarity: " + it);
        }
        return true;
    }

    public static boolean matches(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, OneOf oneOf) {
        for (DistinctPeculiarity<?> it : oneOf.pecularities()) {
            if (!PeculiarityInspector.matches(attributeExtractorLookup, matcherLookup, it)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean matches(AttributeExtractorLookup attributeExtractorLookup, MatcherLookup matcherLookup, DistinctPeculiarity<T> peculiarity) {
        Attribute attribute = peculiarity.attribute();
        Optional<AttributeExtractor<AttributeExtractor, Attribute<AttributeExtractor>>> extractor = attributeExtractorLookup.extractor(attribute);
        Optional value = extractor.flatMap(it -> it.extract(attribute));
        Match match = peculiarity.match();
        Optional<Matcher<Matcher, Match<Matcher>>> matcher = matcherLookup.matcher(match);
        return matcher.map(m -> m.match(value, match)).orElse(false);
    }
}

