/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.packageresolver;

import de.flapdoodle.embed.mongo.packageresolver.DistributionMatch;
import de.flapdoodle.embed.mongo.packageresolver.HasExplanation;
import de.flapdoodle.embed.mongo.packageresolver.HasLabel;
import de.flapdoodle.embed.mongo.packageresolver.HasPlatformMatchRules;
import de.flapdoodle.embed.mongo.packageresolver.NumericVersion;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinder;
import de.flapdoodle.embed.mongo.packageresolver.PackageFinderRules;
import de.flapdoodle.embed.mongo.packageresolver.PlatformMatch;
import de.flapdoodle.embed.mongo.packageresolver.ToolVersionRange;
import de.flapdoodle.embed.mongo.packageresolver.VersionRange;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExplainRules {
    private ExplainRules() {
    }

    static String explain(PackageFinderRules rules) {
        Output output = new Output();
        ExplainRules.explain((Context)output.root(), rules);
        return output.asString();
    }

    static void explain(Context context, PackageFinderRules rules) {
        rules.rules().forEach(rule -> {
            context.matching(ExplainRules.explainMatch(rule.match()));
            PackageFinder finder = rule.finder();
            ExplainRules.explain(context, finder);
        });
    }

    public static void explain(Context context, PackageFinder finder) {
        if (finder instanceof HasLabel) {
            context.label(((HasLabel)((Object)finder)).label());
        }
        if (finder instanceof HasPlatformMatchRules) {
            ExplainRules.explain(context.oneDeeper(), ((HasPlatformMatchRules)((Object)finder)).rules());
        } else {
            context.finder(ExplainRules.finder(finder));
        }
    }

    public static String finder(PackageFinder finder) {
        return finder instanceof HasExplanation ? ((HasExplanation)((Object)finder)).explain() : finder.getClass().getSimpleName();
    }

    public static String finderLabel(PackageFinder finder) {
        return finder instanceof HasLabel ? ((HasLabel)((Object)finder)).label() : finder.getClass().getSimpleName();
    }

    static String explainMatch(DistributionMatch match) {
        return (String)((Optional)ExplainRules.forType(DistributionMatch.class).mapIfInstance(PlatformMatch.class, ExplainRules::explainPlatformMatch).orMapIfInstance(DistributionMatch.AndThen.class, andThen -> "" + ExplainRules.explainMatch(andThen.first()) + " and " + ExplainRules.explainMatch(andThen.second())).orMapIfInstance(DistributionMatch.Any.class, any -> any.matcher().stream().map(ExplainRules::explainMatch).collect(Collectors.joining(" or ", "(", ")"))).orMapIfInstance(VersionRange.class, ExplainRules::explainVersionRange).orMapIfInstance(ToolVersionRange.class, ExplainRules::explainToolsVersionRange).orMapIfInstance(DistributionMatch.class, it -> it.getClass().getSimpleName()).apply(match)).get();
    }

    static String explainPlatformMatch(PlatformMatch match) {
        ArrayList<String> parts = new ArrayList<String>();
        match.os().ifPresent(os -> parts.add("os=" + os));
        match.bitSize().ifPresent(bitSize -> parts.add("bitSize=" + bitSize));
        match.cpuType().ifPresent(cpuType -> parts.add("cpuType=" + cpuType));
        if (!match.version().isEmpty()) {
            parts.add(match.version().stream().map(version -> "" + version).collect(Collectors.joining(", ", "(version is any of ", ")")));
        }
        return !parts.isEmpty() ? parts.stream().collect(Collectors.joining(" and ", "(", ")")) : "(any)";
    }

    private static String explainVersionRange(VersionRange versionRange) {
        if (versionRange.min().isEqual(versionRange.max())) {
            return ExplainRules.asHumanReadable(versionRange.min());
        }
        return ExplainRules.asHumanReadable(versionRange.min()) + "-" + ExplainRules.asHumanReadable(versionRange.max());
    }

    private static String explainToolsVersionRange(ToolVersionRange versionRange) {
        if (versionRange.min().isEqual(versionRange.max())) {
            return "tools.version " + ExplainRules.asHumanReadable(versionRange.min());
        }
        return "tools.version " + ExplainRules.asHumanReadable(versionRange.min()) + "-" + ExplainRules.asHumanReadable(versionRange.max());
    }

    private static String asHumanReadable(NumericVersion version) {
        return version.asString();
    }

    private static String indent(int level) {
        return ExplainRules.repeat(' ', level * 2);
    }

    private static String repeat(char c, int level) {
        char[] s = new char[level];
        for (int i = 0; i < level; ++i) {
            s[i] = c;
        }
        return String.valueOf(s);
    }

    public static <S> HasOptionalBuilder<S> forType(Class<S> sourceType) {
        return new HasOptionalBuilder();
    }

    static <S, T extends S, V> HasOptionalResult<S, V> mapIfInstance(Class<T> type, Function<T, V> mapIfTypeMatches) {
        return s -> type.isInstance(s) ? Optional.of(mapIfTypeMatches.apply(type.cast(s))) : Optional.empty();
    }

    static interface HasOptionalResult<S, V>
    extends Function<S, Optional<V>> {
        default public HasOptionalResult<S, V> or(HasOptionalResult<S, V> other) {
            HasOptionalResult that = this;
            return s -> {
                Optional first = (Optional)that.apply(s);
                return first.isPresent() ? first : (Optional)other.apply(s);
            };
        }

        default public <T extends S> HasOptionalResult<S, V> orMapIfInstance(Class<T> type, Function<T, V> mapIfTypeMatches) {
            return this.or(ExplainRules.mapIfInstance(type, mapIfTypeMatches));
        }
    }

    static class HasOptionalBuilder<S> {
        HasOptionalBuilder() {
        }

        <T extends S, V> HasOptionalResult<S, V> mapIfInstance(Class<T> type, Function<T, V> mapIfTypeMatches) {
            return ExplainRules.mapIfInstance(type, mapIfTypeMatches);
        }
    }

    private static class Output {
        private final StringBuilder sb = new StringBuilder();
        private final String NEW_LINE = System.lineSeparator();

        private Output() {
        }

        public String asString() {
            return this.sb.toString();
        }

        public ContextImpl root() {
            return new ContextImpl(0);
        }

        class ContextImpl
        implements Context {
            private final int level;

            public ContextImpl(int level) {
                this.level = level;
            }

            @Override
            public ContextImpl oneDeeper() {
                return new ContextImpl(this.level + 1);
            }

            @Override
            public void label(String label) {
                Output.this.sb.append(ExplainRules.indent(this.level)).append("'").append(label).append("'").append(Output.this.NEW_LINE);
            }

            @Override
            public void matching(String explainMatch) {
                Output.this.sb.append(ExplainRules.indent(this.level)).append(explainMatch).append(Output.this.NEW_LINE);
            }

            @Override
            public void finder(String finderExplained) {
                Output.this.sb.append(ExplainRules.indent(this.level + 1)).append(finderExplained).append(Output.this.NEW_LINE);
            }
        }
    }

    public static interface Context {
        public Context oneDeeper();

        public void label(String var1);

        public void matching(String var1);

        public void finder(String var1);
    }
}

