/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.spring.autoconfigure;

import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class TypedBeanPostProcessor<T>
implements BeanPostProcessor {
    private final Class<T> type;
    private final Function<T, T> beforeInit;
    private final Function<T, T> afterInit;

    public TypedBeanPostProcessor(Class<T> type, Function<T, T> beforeInit, Function<T, T> afterInit) {
        this.type = type;
        this.beforeInit = beforeInit;
        this.afterInit = afterInit;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.type.isInstance(bean)) {
            return this.beforeInit.apply(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.type.isInstance(bean)) {
            return this.afterInit.apply(bean);
        }
        return bean;
    }

    public static <T> TypedBeanPostProcessor<T> applyBeforeInitialization(Class<T> type, Function<T, T> change) {
        return new TypedBeanPostProcessor<T>(type, change, Function.identity());
    }
}

