/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.process.config.store.IPackageResolver;
import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.distribution.BitSize;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.distribution.Platform;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Paths
implements IPackageResolver {
    private static Logger logger = Logger.getLogger(Paths.class.getName());
    private final Command command;

    public Paths(Command command) {
        this.command = command;
    }

    public Pattern executeablePattern(Distribution distribution) {
        return Pattern.compile(".*" + this.executableFilename(distribution));
    }

    public String executableFilename(Distribution distribution) {
        String mongodPattern;
        switch (distribution.getPlatform()) {
            case Linux: 
            case OS_X: {
                mongodPattern = this.command.commandName();
                break;
            }
            case Windows: {
                mongodPattern = this.command.commandName() + ".exe";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return mongodPattern;
    }

    public ArchiveType getArchiveType(Distribution distribution) {
        ArchiveType archiveType;
        switch (distribution.getPlatform()) {
            case Linux: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            case Windows: {
                archiveType = ArchiveType.ZIP;
                break;
            }
            case OS_X: {
                archiveType = ArchiveType.TGZ;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        return archiveType;
    }

    public String getPath(Distribution distribution) {
        String sbitSize;
        String splatform;
        String sarchiveType;
        String sversion = Paths.getVersionPart(distribution.getVersion());
        ArchiveType archiveType = this.getArchiveType(distribution);
        switch (archiveType) {
            case TGZ: {
                sarchiveType = "tgz";
                break;
            }
            case ZIP: {
                sarchiveType = "zip";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ArchiveType " + archiveType);
            }
        }
        switch (distribution.getPlatform()) {
            case Linux: {
                splatform = "linux";
                break;
            }
            case Windows: {
                splatform = "win32";
                break;
            }
            case OS_X: {
                splatform = "osx";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
        }
        block9 : switch (distribution.getBitsize()) {
            case B32: {
                switch (distribution.getPlatform()) {
                    case Linux: {
                        sbitSize = "i686";
                        break block9;
                    }
                    case Windows: {
                        sbitSize = "i386";
                        break block9;
                    }
                    case OS_X: {
                        sbitSize = "i386";
                        break block9;
                    }
                }
                throw new IllegalArgumentException("Unknown Platform " + distribution.getPlatform());
            }
            case B64: {
                sbitSize = "x86_64";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown BitSize " + distribution.getBitsize());
            }
        }
        if (distribution.getBitsize() == BitSize.B64 && distribution.getPlatform() == Platform.Windows && this.useWindows2008PlusVersion()) {
            sversion = "2008plus-" + sversion;
        }
        return splatform + "/mongodb-" + splatform + "-" + sbitSize + "-" + sversion + "." + sarchiveType;
    }

    protected boolean useWindows2008PlusVersion() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Windows Server 2008 R2")) {
            return true;
        }
        return osName.contains("Windows 7");
    }

    protected static String getVersionPart(IVersion version) {
        return version.asInDownloadPath();
    }
}

