/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.ImmutableMongoRestoreConfig;
import de.flapdoodle.embed.mongo.config.MongoCommonConfig;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.immutables.value.Value;

@Value.Immutable
public interface MongoRestoreConfig
extends MongoCommonConfig {
    @Value.Default
    default public boolean isVerbose() {
        return false;
    }

    public Optional<String> getDatabaseName();

    public Optional<String> getCollectionName();

    public OptionalLong getOplogLimit();

    public Optional<String> getArchive();

    public Optional<String> getDir();

    public OptionalInt getNumberOfParallelCollections();

    public OptionalInt getNumberOfInsertionWorkersPerCollection();

    public Optional<String> getWriteConcern();

    @Value.Default
    default public boolean isObjectCheck() {
        return false;
    }

    @Value.Default
    default public boolean isOplogReplay() {
        return false;
    }

    @Value.Default
    default public boolean isRestoreDbUsersAndRoles() {
        return false;
    }

    @Value.Default
    default public boolean isGzip() {
        return false;
    }

    public boolean isDropCollection();

    @Value.Default
    default public boolean isNoIndexRestore() {
        return false;
    }

    @Value.Default
    default public boolean isNoOptionsRestore() {
        return false;
    }

    @Value.Default
    default public boolean isKeepIndexVersion() {
        return false;
    }

    @Value.Default
    default public boolean isMaintainInsertionOrder() {
        return false;
    }

    @Value.Default
    default public boolean isStopOnError() {
        return false;
    }

    @Value.Default
    default public boolean isBypassDocumentValidation() {
        return false;
    }

    @Override
    @Value.Default
    default public String pidFile() {
        return "mongorestore.pid";
    }

    @Value.Default
    default public de.flapdoodle.embed.process.config.SupportConfig supportConfig() {
        return new SupportConfig(Command.MongoRestore);
    }

    public static ImmutableMongoRestoreConfig.Builder builder() {
        return ImmutableMongoRestoreConfig.builder();
    }
}

