/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.config.MongoCommonConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamProcessor;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoProcess<T extends MongoCommonConfig, E extends Executable<T, P>, P extends IStopable>
extends AbstractProcess<T, E, P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMongoProcess.class);
    private boolean stopped;

    public AbstractMongoProcess(Distribution distribution, T config, RuntimeConfig runtimeConfig, E executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
    }

    protected final void onAfterProcessStart(ProcessControl process, RuntimeConfig runtimeConfig) {
        ProcessOutput outputConfig = runtimeConfig.processOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(this.successMessage(), this.knownFailureMessages(), StreamToLineProcessor.wrap((StreamProcessor)outputConfig.output()));
        Processors.connect((Reader)process.getReader(), (StreamProcessor)logWatch);
        Processors.connect((Reader)process.getError(), (StreamProcessor)StreamToLineProcessor.wrap((StreamProcessor)outputConfig.error()));
        logWatch.waitForResult(((MongoCommonConfig)this.getConfig()).timeout().getStartupTimeout());
        if (logWatch.isInitWithSuccess()) {
            this.setProcessId(Mongod.getMongodProcessId(logWatch.getOutput(), -1));
        } else {
            String failureFound = logWatch.getFailureFound();
            if (failureFound == null) {
                failureFound = "\n----------------------\nHmm.. no failure message.. \n...the cause must be somewhere in the process output\n----------------------\n" + logWatch.getOutput();
            }
            try {
                if (process.waitFor() != 0) {
                    throw new RuntimeException("Could not start process: " + failureFound);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Could not start process: " + failureFound, e);
            }
        }
    }

    protected String successMessage() {
        return "waiting for connections on port";
    }

    private Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        ret.add("error command line");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInternal() {
        AbstractMongoProcess abstractMongoProcess = this;
        synchronized (abstractMongoProcess) {
            if (!this.stopped) {
                this.stopped = true;
                LOGGER.debug("try to stop mongod");
                if (!this.sendStopToMongoInstance()) {
                    LOGGER.warn("could not stop mongod with db command, try next");
                    if (!this.sendKillToProcess()) {
                        LOGGER.warn("could not stop mongod, try next");
                        if (!this.tryKillToProcess()) {
                            LOGGER.warn("could not stop mongod the second time, try one last thing");
                        }
                    }
                }
                this.stopProcess();
            }
        }
    }

    protected void cleanupInternal() {
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
    }

    protected final boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(((MongoCommonConfig)this.getConfig()).net().getServerAddress(), ((MongoCommonConfig)this.getConfig()).net().getPort());
        }
        catch (UnknownHostException e) {
            LOGGER.error("sendStop", (Throwable)e);
            return false;
        }
    }
}

