/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.AuthenticationSetup;
import de.flapdoodle.embed.mongo.client.ExecuteMongoClientAction;
import de.flapdoodle.embed.mongo.client.ImmutableMongoClientAction;
import de.flapdoodle.embed.mongo.client.MongoClientAction;
import de.flapdoodle.embed.mongo.client.UsernamePassword;
import de.flapdoodle.embed.mongo.commands.ServerAddress;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Feature;
import de.flapdoodle.embed.mongo.transitions.RunningMongoProcess;
import de.flapdoodle.embed.mongo.transitions.RunningMongodProcess;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.types.Try;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientActions {
    private static Logger logger = LoggerFactory.getLogger(ClientActions.class);

    private ClientActions() {
    }

    public static Listener setupAuthentication(ExecuteMongoClientAction<?> executeAction, String databaseName, AuthenticationSetup setup) {
        List<Object> setupRoles;
        Listener.TypedListener.Builder typedBuilder = Listener.typedBuilder();
        StateID expectedState = StateID.of(RunningMongodProcess.class);
        UsernamePassword admin = setup.admin();
        ImmutableMongoClientAction createAdminUser = MongoClientAction.runCommand("admin", MongoClientAction.createUser(admin.name(), admin.passwordAsString(), Arrays.asList("root")));
        if (setup.entries().isEmpty()) {
            setupRoles = Arrays.asList(MongoClientAction.createUser(databaseName, admin.name(), admin.password(), "readWrite").withCredentials(MongoClientAction.credentials("admin", admin.name(), admin.password())), MongoClientAction.runCommand(databaseName, MongoClientAction.listCollections()).withCredentials(MongoClientAction.credentials(databaseName, admin.name(), admin.password())));
        } else {
            MongoClientAction.Credentials adminCredentials = MongoClientAction.credentials("admin", admin.name(), admin.password());
            setupRoles = setup.entries().stream().map(entry -> {
                if (entry instanceof AuthenticationSetup.Role) {
                    AuthenticationSetup.Role role = (AuthenticationSetup.Role)entry;
                    return MongoClientAction.runCommand(role.database(), MongoClientAction.createRole(role.name(), MongoClientAction.privilege(role.database(), role.collection(), role.actions()))).withCredentials(adminCredentials);
                }
                if (entry instanceof AuthenticationSetup.User) {
                    AuthenticationSetup.User user = (AuthenticationSetup.User)entry;
                    return MongoClientAction.runCommand(user.database(), MongoClientAction.createUser(user.user().name(), user.user().passwordAsString(), user.roles())).withCredentials(adminCredentials);
                }
                throw new IllegalArgumentException("not supported: " + entry);
            }).collect(Collectors.toList());
        }
        typedBuilder.onStateReached(expectedState, ClientActions.executeClientActions(executeAction, createAdminUser).andThen(ClientActions.executeClientActions(executeAction, setupRoles)));
        typedBuilder.onStateTearDown(StateID.of(RunningMongodProcess.class), ClientActions.executeClientActions(executeAction, ClientActions.shutdown(admin.name(), admin.password())).andThen(RunningMongoProcess::shutDownCommandAlreadyExecuted));
        return typedBuilder.build();
    }

    public static Listener initReplicaSet(ExecuteMongoClientAction<?> executeAction, IFeatureAwareVersion version, Storage replication) {
        return ClientActions.initReplicaSet(executeAction, version, replication, Optional.empty());
    }

    public static Listener initReplicaSet(ExecuteMongoClientAction<?> executeAction, IFeatureAwareVersion version, Storage replication, Optional<UsernamePassword> adminUser) {
        Listener.TypedListener.Builder builder = Listener.typedBuilder();
        Optional<MongoClientAction.Credentials> credentials = adminUser.map(it -> MongoClientAction.credentials("admin", it.name(), it.password()));
        if (version.enabled(Feature.RS_INITIATE)) {
            Consumer<RunningMongodProcess> initReplicaSet = runningMongodProcess -> {
                ServerAddress serverAddress = runningMongodProcess.getServerAddress();
                executeAction.execute((RunningMongodProcess)((Object)runningMongodProcess), MongoClientAction.runCommand("admin", new Document("replSetInitiate", (Object)new Document("_id", (Object)replication.getReplSetName()).append("members", Collections.singletonList(new Document("_id", (Object)0).append("host", (Object)(serverAddress.getHost() + ":" + serverAddress.getPort())))))).withCredentials(credentials));
            };
            builder.onStateReached(StateID.of(RunningMongodProcess.class), initReplicaSet.andThen(runningMongodProcess -> {
                long diff;
                AtomicBoolean isMaster = new AtomicBoolean();
                ImmutableMongoClientAction checkIfMaster = MongoClientAction.runCommand("admin", new Document("isMaster", (Object)1)).withOnResult(doc -> isMaster.set(doc.getBoolean((Object)"ismaster"))).withCredentials(credentials);
                long started = System.currentTimeMillis();
                do {
                    executeAction.execute((RunningMongodProcess)((Object)runningMongodProcess), checkIfMaster);
                    diff = System.currentTimeMillis() - started;
                    logger.info("check if server is elected as master: {} (after {} ms)", (Object)isMaster.get(), (Object)diff);
                    Try.run(() -> Thread.sleep(100L));
                } while (!isMaster.get() && diff < 1000L);
                if (!isMaster.get()) {
                    throw new IllegalArgumentException("initReplicaSet failed to elect " + runningMongodProcess.getServerAddress() + " as master after " + Duration.ofMillis(diff));
                }
            }));
        }
        return builder.build();
    }

    private static Consumer<RunningMongodProcess> executeClientActions(ExecuteMongoClientAction<?> executeAction, MongoClientAction ... actions) {
        return runningMongodProcess -> ClientActions.executeClientActions(executeAction, runningMongodProcess, Arrays.asList(actions));
    }

    private static Consumer<RunningMongodProcess> executeClientActions(ExecuteMongoClientAction<?> executeAction, List<? extends MongoClientAction> actions) {
        return runningMongodProcess -> ClientActions.executeClientActions(executeAction, runningMongodProcess, actions);
    }

    private static void executeClientActions(ExecuteMongoClientAction<?> executeAction, RunningMongodProcess runningMongodProcess, List<? extends MongoClientAction> actions) {
        for (MongoClientAction mongoClientAction : actions) {
            executeAction.execute(runningMongodProcess, mongoClientAction);
        }
    }

    private static MongoClientAction shutdown(String username, char[] password) {
        return MongoClientAction.shutdown("admin").withCredentials(MongoClientAction.credentials("admin", username, password)).withOnError(ex -> logger.debug("expected send shutdown exception", (Throwable)ex));
    }
}

