/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.client;

import de.flapdoodle.embed.mongo.client.ImmutableAuthenticationSetup;
import de.flapdoodle.embed.mongo.client.ImmutableRole;
import de.flapdoodle.embed.mongo.client.ImmutableUser;
import de.flapdoodle.embed.mongo.client.UsernamePassword;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class AuthenticationSetup {
    @Value.Parameter
    protected abstract UsernamePassword admin();

    @Value.Default
    protected List<Entry> entries() {
        return Collections.emptyList();
    }

    public static ImmutableRole role(String database, String collection, String name) {
        return ImmutableRole.of(database, collection, name);
    }

    public static ImmutableUser user(String database, UsernamePassword usernamePassword) {
        return ImmutableUser.of(database, usernamePassword);
    }

    public static ImmutableAuthenticationSetup of(UsernamePassword adminUsernamePassword) {
        return ImmutableAuthenticationSetup.of(adminUsernamePassword);
    }

    @Value.Immutable
    public static interface User
    extends Entry {
        @Value.Parameter
        public String database();

        @Value.Parameter
        public UsernamePassword user();

        public List<String> roles();
    }

    @Value.Immutable
    public static interface Role
    extends Entry {
        @Value.Parameter
        public String database();

        @Value.Parameter
        public String collection();

        @Value.Parameter
        public String name();

        public List<String> actions();
    }

    public static interface Entry {
    }
}

