/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.distribution.ArchiveType;
import de.flapdoodle.embed.process.extract.ArchiveIsFileExtractor;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.TgzExtractor;
import de.flapdoodle.embed.process.extract.ZipExtractor;

public class Extractors {
    private Extractors() {
    }

    public static IExtractor getExtractor(ArchiveType archiveType) {
        switch (archiveType) {
            case TGZ: {
                return new TgzExtractor();
            }
            case EXE: {
                return new ArchiveIsFileExtractor();
            }
            case ZIP: {
                return new ZipExtractor();
            }
        }
        throw new IllegalArgumentException("ArciveType " + (Object)((Object)archiveType) + " not supported");
    }
}

