/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.collections.Collections;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessControl {
    private static Logger logger = Logger.getLogger(ProcessControl.class.getName());
    public static final int SLEEPT_TIMEOUT = 10;
    private Process process;
    private InputStreamReader reader;
    private InputStreamReader error;
    private Integer pid;
    private ISupportConfig runtime;

    public ProcessControl(ISupportConfig runtime, Process process) {
        this.process = process;
        this.runtime = runtime;
        this.reader = new InputStreamReader(this.process.getInputStream());
        this.error = new InputStreamReader(this.process.getErrorStream());
        this.pid = this.getProcessID();
    }

    public Reader getReader() {
        return this.reader;
    }

    public InputStreamReader getError() {
        return this.error;
    }

    public int stop() {
        return this.waitForProcessGotKilled();
    }

    private void closeIOAndDestroy() {
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
            }
            catch (IOException e) {
                logger.severe(e.getMessage());
            }
            this.reader = null;
        }
    }

    private Integer stopOrDestroyProcess() {
        Integer returnCode;
        block12: {
            returnCode = null;
            try {
                returnCode = this.process.exitValue();
            }
            catch (IllegalThreadStateException itsx) {
                Callable<Integer> callable = new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ProcessControl.this.process.waitFor();
                    }
                };
                FutureTask<Integer> task = new FutureTask<Integer>(callable);
                new Thread(task).start();
                boolean stopped = false;
                try {
                    returnCode = task.get(100L, TimeUnit.MILLISECONDS);
                    stopped = true;
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
                this.closeIOAndDestroy();
                try {
                    returnCode = task.get(900L, TimeUnit.MILLISECONDS);
                    stopped = true;
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
                if (stopped) break block12;
                this.process.destroy();
            }
        }
        return returnCode;
    }

    private int waitForProcessGotKilled() {
        Integer retCode = this.stopOrDestroyProcess();
        if (retCode == null) {
            String message = "\n\n----------------------------------------------------\nSomething bad happend. We couldn't kill " + this.runtime.getName() + " process, and tried a lot.\n" + "If you want this problem solved you can help us if you open a new issue.\n" + "\n" + "Follow this link:\n" + this.runtime.getSupportUrl() + "\n" + "Thank you:)\n" + "----------------------------------------------------\n\n";
            throw new IllegalStateException("Couldn't kill " + this.runtime.getName() + " process!" + message);
        }
        return retCode;
    }

    public static ProcessControl fromCommandLine(ISupportConfig runtime, List<String> commandLine, boolean redirectErrorStream) throws IOException {
        ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(commandLine, redirectErrorStream);
        return ProcessControl.start(runtime, processBuilder);
    }

    public static ProcessControl start(ISupportConfig runtime, ProcessBuilder processBuilder) throws IOException {
        return new ProcessControl(runtime, processBuilder.start());
    }

    public static ProcessBuilder newProcessBuilder(List<String> commandLine, boolean redirectErrorStream) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        if (redirectErrorStream) {
            processBuilder.redirectErrorStream();
        }
        return processBuilder;
    }

    public static boolean executeCommandLine(ISupportConfig support, String label, ProcessConfig processConfig) {
        boolean ret = false;
        List<String> commandLine = processConfig.getCommandLine();
        try {
            ProcessControl process = ProcessControl.fromCommandLine(support, processConfig.getCommandLine(), processConfig.getError() == null);
            Processors.connect(process.getReader(), processConfig.getOutput());
            Thread.sleep(10L);
            ret = process.stop() == 0;
            logger.info("execSuccess: " + ret + " " + commandLine);
            return ret;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "" + commandLine, e);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "" + commandLine, e);
        }
        return false;
    }

    public static boolean killProcess(ISupportConfig support, Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Linux || platform == Platform.OS_X) {
            return ProcessControl.executeCommandLine(support, "[kill process]", new ProcessConfig(Collections.newArrayList("kill", "-2", "" + pid), output));
        }
        return false;
    }

    public static boolean tryKillProcess(ISupportConfig support, Platform platform, IStreamProcessor output, int pid) {
        if (platform == Platform.Windows) {
            return ProcessControl.executeCommandLine(support, "[taskkill process]", new ProcessConfig(Collections.newArrayList("taskkill", "/F", "/pid", "" + pid), output));
        }
        return false;
    }

    private Integer getProcessID() {
        Class<?> clazz = this.process.getClass();
        try {
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(this.process);
                if (value instanceof Integer) {
                    return (Integer)value;
                }
            }
        }
        catch (SecurityException sx) {
            sx.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public static void addShutdownHook(Runnable runable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runable));
    }
}

