package de.flapdoodle.collections;

import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Pair;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ImmutableTypedMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code GeneratedImmutableTypedMap.builder()}.
 */
@Generated(from = "ImmutableTypedMap", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GeneratedImmutableTypedMap<K> extends ImmutableTypedMap<K> {
  private final Map<Pair<K, ? extends TypeInfo<?>>, Object> map;

  private GeneratedImmutableTypedMap(
      Map<Pair<K, ? extends TypeInfo<?>>, Object> map) {
    this.map = map;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  protected Map<Pair<K, ? extends TypeInfo<?>>, Object> map() {
    return map;
  }

  /**
   * Copy the current immutable object by replacing the {@link ImmutableTypedMap#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final GeneratedImmutableTypedMap<K> withMap(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
    if (this.map == entries) return this;
    Map<Pair<K, ? extends TypeInfo<?>>, Object> newValue = createUnmodifiableMap(true, false, entries);
    return new GeneratedImmutableTypedMap<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code GeneratedImmutableTypedMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GeneratedImmutableTypedMap<?>
        && equalTo(0, (GeneratedImmutableTypedMap<?>) another);
  }

  private boolean equalTo(int synthetic, GeneratedImmutableTypedMap<?> another) {
    return map.equals(another.map);
  }

  /**
   * Computes a hash code from attributes: {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ImmutableTypedMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImmutableTypedMap{"
        + "map=" + map
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long KEY_SET_LAZY_INIT_BIT = 0x1L;

  private transient Set<Pair<K, ? extends TypeInfo<?>>> keySet;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link ImmutableTypedMap#keySet() keySet} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code keySet} attribute
   */
  @Override
  public Set<Pair<K, ? extends TypeInfo<?>>> keySet() {
    if ((lazyInitBitmap & KEY_SET_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & KEY_SET_LAZY_INIT_BIT) == 0) {
          this.keySet = Objects.requireNonNull(super.keySet(), "keySet");
          lazyInitBitmap |= KEY_SET_LAZY_INIT_BIT;
        }
      }
    }
    return keySet;
  }

  /**
   * Creates an immutable copy of a {@link ImmutableTypedMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <K> generic parameter K
   * @param instance The instance to copy
   * @return A copied immutable ImmutableTypedMap instance
   */
  public static <K> GeneratedImmutableTypedMap<K> copyOf(ImmutableTypedMap<K> instance) {
    if (instance instanceof GeneratedImmutableTypedMap<?>) {
      return (GeneratedImmutableTypedMap<K>) instance;
    }
    return GeneratedImmutableTypedMap.<K>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link GeneratedImmutableTypedMap GeneratedImmutableTypedMap}.
   * <pre>
   * GeneratedImmutableTypedMap.&amp;lt;K&amp;gt;builder()
   *    .putMap|putAllMap(de.flapdoodle.types.Pair&amp;lt;K, ? extends de.flapdoodle.reflection.TypeInfo&amp;lt;?&amp;gt;&amp;gt; =&gt; Object) // {@link ImmutableTypedMap#map() map} mappings
   *    .build();
   * </pre>
   * @param <K> generic parameter K
   * @return A new GeneratedImmutableTypedMap builder
   */
  public static <K> GeneratedImmutableTypedMap.Builder<K> builder() {
    return new GeneratedImmutableTypedMap.Builder<>();
  }

  /**
   * Builds instances of type {@link GeneratedImmutableTypedMap GeneratedImmutableTypedMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ImmutableTypedMap", generator = "Immutables")
  public static final class Builder<K> {
    private Map<Pair<K, ? extends TypeInfo<?>>, Object> map = new LinkedHashMap<Pair<K, ? extends TypeInfo<?>>, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImmutableTypedMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K> from(ImmutableTypedMap<K> instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMap(instance.map());
      return this;
    }

    /**
     * Put one entry to the {@link ImmutableTypedMap#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K> putMap(Pair<K, ? extends TypeInfo<?>> key, Object value) {
      this.map.put(
          Objects.requireNonNull(key, "map key"),
          Objects.requireNonNull(value, value == null ? "map value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link ImmutableTypedMap#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K> putMap(Map.Entry<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entry) {
      Pair<K, ? extends TypeInfo<?>> k = entry.getKey();
      Object v = entry.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ImmutableTypedMap#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K> map(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
      this.map.clear();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ImmutableTypedMap#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<K> putAllMap(Map<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> entries) {
      for (Map.Entry<? extends Pair<K, ? extends TypeInfo<?>>, ? extends Object> e : entries.entrySet()) {
        Pair<K, ? extends TypeInfo<?>> k = e.getKey();
        Object v = e.getValue();
        this.map.put(
            Objects.requireNonNull(k, "map key"),
            Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link GeneratedImmutableTypedMap GeneratedImmutableTypedMap}.
     * @return An immutable instance of ImmutableTypedMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GeneratedImmutableTypedMap<K> build() {
      return new GeneratedImmutableTypedMap<>(createUnmodifiableMap(false, false, map));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
