package de.flapdoodle.reflection;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ListTypeInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableListTypeInfo.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableListTypeInfo.of()}.
 */
@Generated(from = "ListTypeInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableListTypeInfo<T> extends ListTypeInfo<T> {
  private final TypeInfo<T> elements;

  private ImmutableListTypeInfo(TypeInfo<T> elements) {
    this.elements = Objects.requireNonNull(elements, "elements");
  }

  private ImmutableListTypeInfo(ImmutableListTypeInfo<T> original, TypeInfo<T> elements) {
    this.elements = elements;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @Override
  public TypeInfo<T> elements() {
    return elements;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ListTypeInfo#elements() elements} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elements
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableListTypeInfo<T> withElements(TypeInfo<T> value) {
    if (this.elements == value) return this;
    TypeInfo<T> newValue = Objects.requireNonNull(value, "elements");
    return new ImmutableListTypeInfo<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableListTypeInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableListTypeInfo<?>
        && equalTo(0, (ImmutableListTypeInfo<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableListTypeInfo<?> another) {
    return elements.equals(another.elements);
  }

  /**
   * Computes a hash code from attributes: {@code elements}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + elements.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListTypeInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListTypeInfo{"
        + "elements=" + elements
        + "}";
  }

  /**
   * Construct a new immutable {@code ListTypeInfo} instance.
 * @param <T> generic parameter T
   * @param elements The value for the {@code elements} attribute
   * @return An immutable ListTypeInfo instance
   */
  public static <T> ImmutableListTypeInfo<T> of(TypeInfo<T> elements) {
    return new ImmutableListTypeInfo<>(elements);
  }

  /**
   * Creates an immutable copy of a {@link ListTypeInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ListTypeInfo instance
   */
  public static <T> ImmutableListTypeInfo<T> copyOf(ListTypeInfo<T> instance) {
    if (instance instanceof ImmutableListTypeInfo<?>) {
      return (ImmutableListTypeInfo<T>) instance;
    }
    return ImmutableListTypeInfo.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableListTypeInfo ImmutableListTypeInfo}.
   * <pre>
   * ImmutableListTypeInfo.&amp;lt;T&amp;gt;builder()
   *    .elements(de.flapdoodle.reflection.TypeInfo&amp;lt;T&amp;gt;) // required {@link ListTypeInfo#elements() elements}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableListTypeInfo builder
   */
  public static <T> ImmutableListTypeInfo.Builder<T> builder() {
    return new ImmutableListTypeInfo.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableListTypeInfo ImmutableListTypeInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ListTypeInfo", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_ELEMENTS = 0x1L;
    private long initBits = 0x1L;

    private TypeInfo<T> elements;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListTypeInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(ListTypeInfo<T> instance) {
      Objects.requireNonNull(instance, "instance");
      elements(instance.elements());
      return this;
    }

    /**
     * Initializes the value for the {@link ListTypeInfo#elements() elements} attribute.
     * @param elements The value for elements 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> elements(TypeInfo<T> elements) {
      this.elements = Objects.requireNonNull(elements, "elements");
      initBits &= ~INIT_BIT_ELEMENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableListTypeInfo ImmutableListTypeInfo}.
     * @return An immutable instance of ListTypeInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableListTypeInfo<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableListTypeInfo<>(null, elements);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ELEMENTS) != 0) attributes.add("elements");
      return "Cannot build ListTypeInfo, some of required attributes are not set " + attributes;
    }
  }
}
